/* CTORRENT Monitor 3 by DGD - starts all .torrents in specified directory */
/* Enhanced OS/2 ctorrent at: http://www.ehlertronic.de/esbin/ctorr-pack.zip
 -Set Firefox to only download; then hit <backspace> in CTM3. Manual method
  avoids possibly never letting a drive spin down (power save) because of
  periodic checking of download_dir. Though you're presumably pulling down
  data, isn't necessarily to same drive as download_dir.
 -Edit this or create directories as below; put ctorrent9.exe in base_dir.
  Program object "working dir" is where torrents will be put. But if run from
  command line, current directory will be used -- possibly DUPLICATING files!
 -All stopping of torrents and this program is manual.
 -Set upload speed to about 80% of your max to not starve other programs!
 -NOTE VERSION CONFUSION DUE TO "BETA" RELEASES. THIS IS VERSION THREE, or 2B+.
*/

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

base_dir= 'C:\TORRENTS'
current_dir= base_dir||'\CURRENT' /* looks here for current ones */
download_dir= 'C:\TEMP' /* <backspace> moves torrents to above dir */
params= '-G -R -U 35 -W 70,4 -Z' /* ctorrent9.exe parameters */
/* Advanced parameters (for OS/2):
-A style        Status line style, 0...2 (default 1)
-G              Show current download % in Window List string.
-I icon         Set icon as...  (default "act.ico")
-O origin       Set window origin (left, bottom) as "x,y"
-R              Show current Down/Up rate in Window List string.
-T title        Set title as... (default torrent filename)
-W dimension    Set window dimension as "column,row"
-Z              Use icon as process indicator.
*/
uparrow= d2c(24)
dnarrow= d2c(25)
updatetime= 30 /* seconds between updates */

/* text screen colors: used for highlighting */
black= 0; red= 1; green= 2; yellow= 3;
blue= 4; magenta= 5; cyan= 6; white= 7;
fgnd = 30   /* add color: 30 + 2 = 32 ==> green foreground */
bgnd = 40   /* add color: 40 + 7 = 47 ==> white background */
AEsc= '1B'x||'['  /* define ANSI-ESCape; + 0 = low, 1 = high int*/
norcolr= AEsc||'0;'||fgnd + white||';'||bgnd + black||'m' /* normal */
pccolr= AEsc||'1;'||fgnd + cyan||';'||bgnd + black||'m' /* percent */
dncolr= AEsc||'1;'||fgnd + green||';'||bgnd + black||'m' /* download */
upcolr= AEsc||'1;'||fgnd + red||';'||bgnd + black||'m' /* upload */
ansi_clreol= AEsc||'K'

/* CONSTANTs for some useful keys; see ex_read_key; MOST not used here */
zky= d2c(0);  xky= d2c(224); /* prefixes for extended keys */
k_esc= x2c('1b');  k_enter= x2c('0d');  k_bksp= d2c(8);  k_tab= d2c(9);
k_up= 'H';    k_down= 'P';  k_left= 'K';  k_right= 'M';
k_ins= 'R';   k_del= 'S';   k_home= 'G';  k_end= 'O';
k_pgup= 'I';  k_pgdn= 'Q';
/* control keys */
k_cleft= 's'; k_cright= 't';  k_cup= ''||d2c(141); k_cdn= ''||d2c(145);
k_cpgup= ''||d2c(132);  k_cpgdn= 'v';
/* function keys */
k_f1= zky||';';  k_f2= zky||'<';  k_f3= zky||'=';  k_f4= zky||'>';
k_f5= zky||'?';  k_f6= zky||'@';  k_f7= zky||'A';  k_f8= zky||'B';
k_f9= zky||'C';  k_f10= zky||'D'; k_f11= zky||d2c(133);  k_f12= zky||d2c(134);

call syscls
initialize= 0
count= updatetime + 1 /* to show info on first pass through below */

do forever  /* main loop */
  if chars() > 0 then do
    k= ex_read_key()
    if k = k_bksp then do
      rc= sysfiletree(download_dir||'\*.torrent', 'torrents.', 'FO')
      do l= 1 to torrents.0
        'copy 'torrents.l' 'current_dir /* copy-del because may not be on */
        'del 'torrents.l   /* same drive, and may be more than one */
      end
      initialize= 0 /* set flag to make call below */
    end
    else call beep 3000, 100
    count= updatetime + 1
  end
  if initialize = 0 then call initialize_all
  if count > updatetime then do  /* new method has 1 sec kyboard latency */
    count= 0
    say   /* much hard-coded formatting - feel free to neaten */
    say norcolr||copies('', 79)
    call sysqueryswitchlist "wlist."
    td= 0; tu= 0
    do n= 1 to wlist.0
    if pos('ACT:', wlist.n) > 0 & pos('%', wlist.n) > 0 then do
      ds= delstr(wlist.n, 1, 5)     /* ^ present only after initialized */
      ds= insert(' ', ds, pos(dnarrow, ds))
      parse value syscurpos() with y x
      call syscurpos y, x + 1  /* separate words, and use colors */
      w1= word(ds, 1)
      do until length(w1) > 5; w1= ' '||w1; end
      call charout, pccolr||w1  /* inserting INTO string didn't work, hmm */
      w2= word(ds, 2)
      do until length(w2) > 7; w2= ' '||w2; end
      call charout, dncolr||w2
      td= td + substr(w2, 1, length(w2) - 1)
      w3= word(ds, 3)
      do until length(w3) > 7; w3= ' '||w3; end
      call charout, upcolr||w3||'  '
      tu= tu + delstr(w3, pos(uparrow, w3), 1)
      w4= substr(ds, wordindex(ds, 4), length(ds) - wordindex(ds, 4) + 1)
      call charout, norcolr||w4
      say
    end /* pos('ACT:' */
    end /* do */
    do until length(td) > 13; td= ' '||td; end
    call charout, dncolr||td' '
    do until length(tu) > 6; tu= ' '||tu; end
    call charout, upcolr||tu
    call charout, norcolr||copies(' ', 20)||'CTM3 Ctorrent Monitor'
  end /* if count */
  call syssleep 1
  count= count + 1
end

initialize_all:
  rc= sysfiletree(current_dir||'\*.torrent', 'torrents.', 'FO')
  do n= torrents.0 to 1 by -1  /* alpha order from file system REVERSES in */
    rv= start_torrent(torrents.n)  /* windows list so reverse order here */
    if pos(rv, torrents.n) > 0 then do  /* rv is either sawl or '' */
      say 'Waiting for ctorrent9 to check existing files.'
      call charout, '<Backspace> to skip wait (and to continue if hangs...)'
      started= 0                /* WAIT until a '%' shows in 'ACT:' window */
      do until started = 1      /* because disk usage is HIGH and several */
        call sysqueryswitchlist "wlist." /* checking at once slows to CRAWL */
        do l= 1 to wlist.0 /* scan all, set flag if found */
          w2= wlist.l /* complex mangling, see start_torrent for why... */
          k= lastpos(uparrow, w2) + 2
          w3= substr(w2, k, length(w2) - k + 1)
          if length(w3) < length(rv) then rv= substr(rv, 1, length(w3))
          if pos(rv, w3) > 0 & pos('%', wlist.l) > 0 then started= 1
        end
        call charout, '.'
        if chars() > 0 then do /* STILL seems to hang with new torrents */
          k= ex_read_key()  /* so with regret, adding this to continue */
          if k = k_bksp then started= 1
        end
        if started = 0 then call syssleep 10
      end /* started */
      say
    end
    else say dncolr||'!!! Appears to be already running! 'norcolr||torrents.n
  end
  initialize= 1
return

start_torrent: /* IF not already running */
  parse arg tts   /* parse so doesn't upcase! */
  call sysqueryswitchlist "wlist."
  sawl= substr(tts, lastpos('\', tts) + 1, length(tts) - lastpos('\', tts))
  sawl= substr(sawl, 1, 42) /* is shortened to 45 or so in window list, but */
  running= 0 /* can only hope is enough to be unique... (later: not always) */
  do l= 1 to wlist.0   /* scan all, set flag if found */
    if pos('ACT:', wlist.l) > 0 then do
      w2= wlist.l /* do some mangling because a simpler check failed when */
      k= lastpos(uparrow, w2) + 2 /* window list is shorter (is randomish, */
      w3= substr(w2, k, length(w2) - k + 1)  /* varies with actual numbers) */
      if length(w3) < length(sawl) then sawl= substr(sawl, 1, length(w3))
      if pos(sawl, w3) > 0 then running= 1
    end
  end
  if running = 0 then do  /* start windowed VIO, in background, minimized */
   'start /WIN /B /MIN 'base_dir||'\ctorrent9.exe 'params' "'tts'"'
   call syssleep 5
  end
  else sawl= '' /* to have some feedback */
return sawl

ex_read_key: /* returns two bytes for extended codes */
  xrkey= sysgetkey('noecho')
  if xrkey = d2c(0) | xrkey = d2c(224) then xrkey= xrkey||sysgetkey('noecho')
return xrkey
