/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.vcard;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.vcard.VCard;
import org.xml.sax.Attributes;

public class VCardHandler
extends ExtensionHandler {
    private Map personal = new HashMap(20);
    private Map business = new HashMap(20);
    private List homeTels = new LinkedList();
    private List workTels = new LinkedList();
    private static int UNKNOWN = 0;
    private static int HOME = 1;
    private static int WORK = 2;
    private static int PHOTO = 3;
    private static int LOGO = 4;
    private int current = UNKNOWN;
    private boolean homeAdresKnown = false;
    private String[] telephoneNumber;
    private String[] photo;
    private String[] logo;

    public void startHandling(Attributes attributes) {
        this.personal.clear();
        this.business.clear();
        this.homeTels.clear();
        this.workTels.clear();
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("TEL")) {
            this.telephoneNumber = new String[3];
        } else if (string.equals("HOME")) {
            this.current = HOME;
        } else if (string.equals("WORK")) {
            this.current = WORK;
        } else if (string.equals("VOICE") || string.equals("FAX") || string.equals("PAGER") || string.equals("MSG") || string.equals("CELL") || string.equals("VIDEO") || string.equals("BBS") || string.equals("MODEM") || string.equals("ISDN") || string.equals("PCS")) {
            if (this.telephoneNumber != null) {
                this.telephoneNumber[1] = string;
            }
        } else if (string.equals("PREF")) {
            if (this.telephoneNumber != null) {
                this.telephoneNumber[2] = "PREF";
            }
        } else if (string.equals("PHOTO")) {
            this.photo = new String[2];
            this.current = PHOTO;
            this.photo[0] = attributes.getValue("TYPE");
        } else if (string.equals("LOGO")) {
            this.logo = new String[2];
            this.current = LOGO;
            this.logo[0] = attributes.getValue("TYPE");
        }
    }

    public void endElement(String string) {
        if (string.equals("NUMBER")) {
            if (this.telephoneNumber != null) {
                this.telephoneNumber[0] = this.getText();
            }
        } else if (string.equals("TEL")) {
            if (this.current == WORK) {
                this.workTels.add(this.telephoneNumber);
            } else {
                this.homeTels.add(this.telephoneNumber);
            }
            this.telephoneNumber = null;
            this.current = UNKNOWN;
        } else if (string.equals("ADR") || string.equals("EMAIL")) {
            this.current = UNKNOWN;
        }
        if (!this.getText().equals("")) {
            if (string.equals("FAMILY") || string.equals("GIVEN") || string.equals("MIDDLE") || string.equals("NICKNAME") || string.equals("BDAY") || string.equals("JABBERID") || string.equals("LAT") || string.equals("LON") || string.equals("URL") || string.equals("DESC") || string.equals("FN")) {
                this.personal.put(string, this.getText());
            } else if (string.equals("TITLE") || string.equals("ROLE") || string.equals("ORGNAME") || string.equals("ORGUNIT")) {
                this.business.put(string, this.getText());
            } else if (string.equals("POBOX") || string.equals("EXTADR") || string.equals("STREET") || string.equals("LOCALITY") || string.equals("REGION") || string.equals("PCODE") || string.equals("CTRY")) {
                if (this.current == WORK) {
                    this.business.put(string, this.getText());
                } else if (this.current == HOME) {
                    this.personal.put(string, this.getText());
                } else if (!this.homeAdresKnown) {
                    this.personal.put(string, this.getText());
                }
            } else if (string.equals("USERID")) {
                if (this.current == WORK) {
                    this.business.put("EMAIL", this.getText());
                } else {
                    this.personal.put("EMAIL", this.getText());
                }
            } else if (string.equals("BINVAL")) {
                if (this.current == PHOTO) {
                    this.photo[1] = this.getText();
                    this.personal.put("PHOTO", this.photo);
                } else if (this.current == LOGO) {
                    this.logo[1] = this.getText();
                    this.business.put("LOGO", this.logo);
                }
                this.current = UNKNOWN;
            }
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        return new VCard(this.personal, this.business, this.homeTels, this.workTels);
    }
}

