/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.drawing.PictureMessageHandler;
import nu.fw.jeti.plugins.drawing.shapes.EllipseFactory;
import nu.fw.jeti.plugins.drawing.shapes.LineFactory;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.PolygonFactory;
import nu.fw.jeti.plugins.drawing.shapes.PolylineFactory;
import nu.fw.jeti.plugins.drawing.shapes.RectangleFactory;
import nu.fw.jeti.plugins.drawing.shapes.Shape;
import nu.fw.jeti.plugins.drawing.shapes.ShapeFactory;
import nu.fw.jeti.plugins.drawing.shapes.TextShapeFactory;
import nu.fw.jeti.util.I18N;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "drawing.whiteboard";
    public static final String MIN_JETI_VERSION = "0.7.6";
    public static final String NAME = "drawing";
    public static final String ABOUT = "by Elabieta Iwaszkiewicz";
    private static HashMap<String, ShapeFactory> shapeFactories;
    private static Random rand;
    private static Map<String, PictureChat> pictureChats;
    private static Backend backend;

    public static void init(Backend backend) {
        backend.addExtensionHandler("http://jeti.sf.net/protocol/whiteboard", (ExtensionHandler)new PictureMessageHandler());
        backend.getMain().addToOnlineRosterMenu(I18N.getText((String)NAME, (String)"Drawing"), new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                Plugin.addPictureChat(jIDStatus.getJID());
            }
        });
        Plugin.backend = backend;
        shapeFactories = new HashMap();
        shapeFactories.put("line", new LineFactory());
        shapeFactories.put("polyline", new PolylineFactory());
        shapeFactories.put("rectangle", new RectangleFactory());
        shapeFactories.put("ellipse", new EllipseFactory());
        shapeFactories.put("polygon", new PolygonFactory());
        shapeFactories.put("text_shape", new TextShapeFactory());
    }

    public static Shape createShape(String string, long l, JID jID, String string2, Color color, int n, boolean bl) {
        return shapeFactories.get(string).createShape(l, jID, string2, color, n, bl);
    }

    public static boolean shapeFactoryContains(String string) {
        return shapeFactories.containsKey(string);
    }

    public static long getRandLong() {
        return rand.nextLong();
    }

    public static void addPictureChat(JID jID) {
        if (pictureChats == null) {
            pictureChats = Collections.synchronizedMap(new HashMap());
        }
        Collection<PictureChat> collection = pictureChats.values();
        Object object = collection.iterator();
        while (object.hasNext()) {
            PictureChat pictureChat = object.next();
            if (jID == null || !jID.equals(pictureChat.getJID())) continue;
            pictureChat.showWindow();
            return;
        }
        object = backend.createThread();
        pictureChats.put((String)object, new PictureChat(backend, jID, (String)object));
    }

    public static PictureChat getPictureChat(JID jID, String string) {
        if (pictureChats == null) {
            pictureChats = Collections.synchronizedMap(new HashMap());
        }
        if (pictureChats.get(string) == null) {
            pictureChats.put(string, new PictureChat(backend, jID, string));
        }
        return pictureChats.get(string);
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        backend.getMain().removeFromRosterMenu(I18N.getText((String)NAME, (String)"Drawing"));
        backend.removeExtensionHandler("http://jeti.sf.net/protocol/whiteboard");
    }

    static {
        rand = new Random();
    }
}

