/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.geometry;

import java.awt.geom.Point2D;

public class Vector {
    private double x;
    private double y;

    public Vector(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector(Point2D.Double double_, Point2D.Double double_2) {
        this.x = double_2.x - double_.x;
        this.y = double_2.y - double_.y;
    }

    public Point2D.Double addVectorToPoint(Point2D.Double double_) {
        return new Point2D.Double(double_.x + this.x, double_.y + this.y);
    }

    public void clear() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public static double crossProduct(Vector vector, Vector vector2) {
        return vector.x * vector2.y - vector.y * vector2.x;
    }

    public static double dotProduct(Vector vector, Vector vector2) {
        return vector.x * vector2.x + vector.y * vector2.y;
    }

    public static boolean pointsInOneLine(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Vector vector = new Vector(double_, double_2);
        Vector vector2 = new Vector(double_, double_3);
        return Vector.crossProduct(vector, vector2) == 0.0;
    }

    public static boolean isAngleBetweenVectorsLessEqual90(Vector vector, Vector vector2) {
        return Vector.dotProduct(vector, vector2) >= 0.0;
    }

    public static boolean isAngleBetweenVectorsLessEqual90(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Vector vector = new Vector(double_2, double_);
        Vector vector2 = new Vector(double_2, double_3);
        return Vector.isAngleBetweenVectorsLessEqual90(vector, vector2);
    }

    public static double distance(Point2D.Double double_, Point2D.Double double_2) {
        return Math.sqrt((double_.x - double_2.x) * (double_.x - double_2.x) + (double_.y - double_2.y) * (double_.y - double_2.y));
    }

    public static double length(Vector vector) {
        return Math.sqrt(vector.x * vector.x + vector.y * vector.y);
    }

    public static double distanceLinePoint(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Vector vector = new Vector(double_, double_3);
        Vector vector2 = new Vector(double_, double_2);
        double d = Vector.length(vector2);
        if (d == 0.0) {
            return 1000000.0;
        }
        return Math.abs(Vector.crossProduct(vector, vector2) / d);
    }

    public Vector getReverseVector() {
        return new Vector(-this.x, -this.y);
    }

    public String toString() {
        return this.x + " " + this.y;
    }
}

