/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.Plugin;
import nu.fw.jeti.plugins.drawing.geometry.Vector;

public abstract class Shape {
    protected final Color DEFAULT_COLOR = Color.black;
    protected static final int INCORRECT_HEIGHT = -1;
    protected Color color;
    protected Color borderColor = Color.BLACK;
    protected Color selectionColor = this.DEFAULT_COLOR;
    protected long shapeId;
    protected JID author;
    protected int displayHeight;
    protected boolean isFilled = false;
    protected final double SURROUND_DIST = 3.0;

    public Shape(long l, JID jID, Color color, int n) {
        this.shapeId = l;
        this.author = jID;
        this.color = color;
        this.displayHeight = n;
    }

    public Color getColor() {
        return this.color;
    }

    public static long generateId() {
        return Plugin.getRandLong();
    }

    public long getShapeId() {
        return this.shapeId;
    }

    public JID getAuthor() {
        return this.author;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public abstract void draw(Graphics var1, int var2, int var3);

    public abstract void drawAsSelected(Graphics var1, int var2, int var3);

    public abstract String getName();

    public abstract String getCoordinates();

    public abstract void setCoordinates(String var1);

    public abstract void changeCoordinates(Vector var1);

    public void setColor(Color color) {
        this.color = color;
    }

    public abstract boolean isInsideTheRect(Point2D.Double var1, Point2D.Double var2);

    public abstract boolean isPointInShapesNeighbourhood(Point2D.Double var1, int var2, int var3);

    protected boolean isPointInLinesNeighbourhood(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, int n, int n2) {
        Point2D.Double double_4;
        Point2D.Double double_5;
        Point2D.Double double_6 = this.ceilTo2DPointl(double_, n, n2);
        return Vector.distanceLinePoint(double_6, double_5 = this.ceilTo2DPointl(double_2, n, n2), double_4 = this.ceilTo2DPointl(double_3, n, n2)) <= 3.0 && Vector.isAngleBetweenVectorsLessEqual90(double_6, double_5, double_4) && Vector.isAngleBetweenVectorsLessEqual90(double_5, double_6, double_4) || Vector.distance(double_6, double_4) <= 3.0 || Vector.distance(double_5, double_4) <= 3.0;
    }

    public abstract Point2D.Double getDisplayPoint();

    protected boolean isPointInRectanglesNeighbourhood(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, int n, int n2) {
        Point point = this.ceil(double_, n, n2);
        int n3 = point.x;
        int n4 = point.y;
        Point point2 = this.ceil(double_2, n, n2);
        Point point3 = this.ceil(double_3, n, n2);
        return (n3 >= point2.x && n3 <= point3.x || (double)Math.abs(point2.x - n3) <= 3.0 || (double)Math.abs(point3.x - n3) <= 3.0) && ((double)Math.abs(point2.y - n4) <= 3.0 || (double)Math.abs(point3.y - n4) <= 3.0) || (n4 >= point2.y && n4 <= point3.y || (double)Math.abs(point2.y - n4) <= 3.0 || (double)Math.abs(point3.y - n4) <= 3.0) && ((double)Math.abs(point2.x - n3) <= 3.0 || (double)Math.abs(point3.x - n3) <= 3.0);
    }

    public abstract boolean isPointInShapesInterior(Point2D.Double var1, int var2, int var3);

    public boolean isHigherThan(Shape shape) {
        if (this.displayHeight > shape.displayHeight) {
            return true;
        }
        return this.displayHeight == shape.displayHeight && this.shapeId > shape.shapeId;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int n) {
        this.displayHeight = n;
    }

    public abstract Point2D.Double getTheMostUpperLeftPoint();

    public abstract Point2D.Double getTheMostBottomRightPoint();

    protected Point2D.Double getTheMostUpperLeftPoint(double[] dArray, double[] dArray2) {
        Point2D.Double double_ = null;
        for (int i = 0; i < dArray.length; ++i) {
            if (double_ == null) {
                double_ = new Point2D.Double(dArray[i], dArray2[i]);
                continue;
            }
            if (dArray[i] < double_.x) {
                double_.x = dArray[i];
            }
            if (!(dArray2[i] < double_.y)) continue;
            double_.y = dArray2[i];
        }
        return double_;
    }

    protected Point2D.Double getTheMostBottomRightPoint(double[] dArray, double[] dArray2) {
        Point2D.Double double_ = null;
        for (int i = 0; i < dArray.length; ++i) {
            if (double_ == null) {
                double_ = new Point2D.Double(dArray[i], dArray2[i]);
                continue;
            }
            if (dArray[i] > double_.x) {
                double_.x = dArray[i];
            }
            if (!(dArray2[i] > double_.y)) continue;
            double_.y = dArray2[i];
        }
        return double_;
    }

    protected int ceil(double d, int n) {
        return (int)(d * (double)n);
    }

    protected Point ceil(Point2D.Double double_, int n, int n2) {
        int n3 = (int)(double_.x * (double)n);
        int n4 = (int)(double_.y * (double)n2);
        return new Point(n3, n4);
    }

    protected Point2D.Double ceilTo2DPointl(Point2D.Double double_, int n, int n2) {
        int n3 = (int)(double_.x * (double)n);
        int n4 = (int)(double_.y * (double)n2);
        return new Point2D.Double(n3, n4);
    }
}

