/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;

public class TextShape
extends Shape {
    private String text;
    private JTextField textField;
    private Font font;
    private double x;
    private double y;
    private double width;
    private double height;
    private boolean isEdited = false;
    private final int TEXT_FIELD_MARGIN = 8;
    public static final String NAME = "text_shape";
    private static final String UNDERLINE = "_";
    private static final String SPACE = "\\s";
    private static final int BASE_WIDTH = 480;
    private static final int BASE_HEIGHT = 360;

    public TextShape(long l, JID jID, String string, Color color, int n) {
        super(l, jID, color, n);
        this.setCoordinates(string);
        this.textField = new JTextField();
    }

    public TextShape(JID jID, Color color, Font font, Point2D.Double double_) {
        super(TextShape.generateId(), jID, color, -1);
        this.x = double_.x;
        this.y = double_.y;
        this.font = font;
        this.textField = new JTextField();
        this.text = "";
    }

    public void draw(Graphics graphics, int n, int n2) {
        Font font = this.setWidthAndHeight(graphics, n, n2);
        if (!this.isEdited) {
            graphics.setColor(this.color);
            graphics.setFont(font);
            int n3 = this.ceil(this.x, n);
            int n4 = this.ceil(this.y, n2);
            int n5 = this.ceil(this.height, n2);
            graphics.drawString(this.text, n3, n4 + n5);
        }
    }

    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        graphics.setColor(this.selectionColor);
        int n3 = this.ceil(this.x, n);
        int n4 = this.ceil(this.y, n2);
        int n5 = this.ceil(this.width, n);
        int n6 = this.ceil(this.height, n2);
        graphics.drawRect(n3, n4, n5, n6);
        graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
        graphics.drawRect(n3 + n5 - 2, n4 - 2, 4, 4);
        graphics.drawRect(n3 + n5 - 2, n4 + n6 - 2, 4, 4);
        graphics.drawRect(n3 - 2, n4 + n6 - 2, 4, 4);
    }

    private Font getScaledFont(int n, int n2) {
        int n3 = this.font.getSize();
        double d = (double)n / 480.0;
        double d2 = (double)n2 / 360.0;
        int n4 = Math.min(this.ceil(d, n3), this.ceil(d2, n3));
        Font font = new Font(this.font.getName(), this.font.getStyle(), n4);
        return font;
    }

    private Font setWidthAndHeight(Graphics graphics, int n, int n2) {
        Font font = this.getScaledFont(n, n2);
        Rectangle2D rectangle2D = this.getTextBounds(graphics, font);
        int n3 = (int)rectangle2D.getWidth() + 1;
        int n4 = (int)rectangle2D.getHeight() + 1;
        this.width = (double)n3 / (double)n;
        this.height = (double)n4 / (double)n2;
        return font;
    }

    private Rectangle2D getTextBounds(Graphics graphics, Font font) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = this.text.equals("") ? new TextLayout("bg", font, fontRenderContext) : new TextLayout(this.text, font, fontRenderContext);
        return textLayout.getBounds();
    }

    private void setTextFieldParameters(Graphics graphics, int n, int n2) {
        Font font = this.setWidthAndHeight(graphics, n, n2);
        this.textField.setText(this.text);
        int n3 = 0;
        n3 = this.text.equals("") ? 70 : 40;
        int n4 = this.ceil(this.x, n);
        int n5 = this.ceil(this.y, n2);
        int n6 = this.ceil(this.width, n);
        int n7 = this.ceil(this.height, n2);
        this.textField.setBounds(n4, n5, n6 + 8 + n3, n7 + 8);
        this.textField.setFont(font);
    }

    public JTextField getTextField(Graphics graphics, int n, int n2) {
        this.setTextFieldParameters(graphics, n, n2);
        return this.textField;
    }

    public void startEditing() {
        this.isEdited = true;
        this.textField.setVisible(true);
    }

    public void stopEditing() {
        this.isEdited = false;
        this.text = this.textField.getText();
        this.textField.setVisible(false);
    }

    public boolean isEmptyText() {
        return this.text.equals("");
    }

    public String getName() {
        return NAME;
    }

    public String getCoordinates() {
        return this.x + " " + this.y + " " + this.changeRegexInString(this.font.getFamily(), SPACE, UNDERLINE) + " " + this.font.getStyle() + " " + this.font.getSize() + " " + this.text;
    }

    private String changeRegexInString(String string, String string2, String string3) {
        String[] stringArray = string.split(string2);
        String string4 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = string4 + stringArray[i] + string3;
        }
        return string4;
    }

    public void setCoordinates(String string) {
        String[] stringArray = string.split(SPACE);
        this.x = Double.parseDouble(stringArray[0]);
        this.y = Double.parseDouble(stringArray[1]);
        this.font = new Font(this.changeRegexInString(stringArray[2], UNDERLINE, SPACE), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
        this.text = "";
        for (int i = 5; i < stringArray.length; ++i) {
            this.text = this.text + stringArray[i] + " ";
        }
    }

    public void changeCoordinates(Vector vector) {
        Point2D.Double double_ = vector.addVectorToPoint(new Point2D.Double(this.x, this.y));
        this.x = double_.x;
        this.y = double_.y;
    }

    public boolean isInsideTheRect(Point2D.Double double_, Point2D.Double double_2) {
        return PointsOperations.pointIsInsideRect(new Point2D.Double(this.x, this.y), double_, double_2) && PointsOperations.pointIsInsideRect(new Point2D.Double(this.x + this.width, this.y + this.height), double_, double_2);
    }

    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        return this.isPointInShapesInterior(double_, n, n2) || this.isPointInRectanglesNeighbourhood(double_, new Point2D.Double(this.x, this.y), new Point2D.Double(this.x + this.width, this.y + this.height), n, n2);
    }

    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        return PointsOperations.pointIsInsideRect(double_, new Point2D.Double(this.x, this.y), new Point2D.Double(this.x + this.width, this.y + this.height));
    }

    public Point2D.Double getDisplayPoint() {
        return PointsOperations.getMiddlePoint(new Point2D.Double(this.x, this.y), new Point2D.Double(this.x + this.width, this.y));
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        return new Point2D.Double(this.x + this.width, this.y + this.height);
    }
}

