/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.shapes.Shape;
import nu.fw.jeti.plugins.drawing.ui.Mode;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;

public class Board
extends JPanel {
    private PictureChat chat;
    private Color currentColor = Color.BLACK;
    private Color selectionColor = Color.BLACK;
    private final Color SELECTION_BACKGROUND_COLOR = new Color(153, 0, 153, 35);
    private Shape currentShape = null;
    private int currentTransparency = 255;
    private PicturesContent picture;
    private Mode currentMode;
    private String fontFamily = "Serif";
    private int fontSize = 12;
    private int fontStyle = 0;
    private static final long serialVersionUID = 1L;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private Color currentBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    private Color fontForegroundColor = Color.BLACK;
    private Color fontBackgroundColor = DEFAULT_BACKGROUND_COLOR;

    public Board(PictureChat pictureChat, PicturesContent picturesContent) {
        this.chat = pictureChat;
        this.picture = picturesContent;
        this.addMouseListener(new MouseL());
        this.addMouseMotionListener(new MouseMotionL());
        this.picture.addListener(new PictureChangeListener());
        this.setFocusable(true);
        this.setBackground(this.currentBackgroundColor);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
    }

    public void setCurrentMode(Mode mode) {
        if (this.currentMode != null) {
            this.currentMode.dispose();
        }
        this.currentMode = mode;
        this.repaint();
    }

    protected void setCurrentShape(Shape shape) {
        this.currentShape = shape;
    }

    protected Shape getCurrentShape() {
        return this.currentShape;
    }

    protected Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        this.picture.drawPictureWithSelection(graphics, dimension.width, dimension.height);
        if (this.currentShape != null) {
            this.currentShape.draw(graphics, dimension.width, dimension.height);
        }
    }

    public void setCurrentColor(Color color) {
        this.currentColor = color;
        this.setFontForegroundColor(color);
        this.requestFocusInWindow();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point2D.Double double_ = this.scaleToZeroOne(mouseEvent.getPoint());
        Dimension dimension = this.getSize();
        JID jID = this.chat.getAuthor(double_, dimension.width, dimension.height);
        if (jID != null) {
            UserRepresentation userRepresentation = new UserRepresentation(jID);
            return userRepresentation.toString();
        }
        return null;
    }

    public void addTextField(JTextField jTextField) {
        this.add(jTextField);
        jTextField.grabFocus();
        jTextField.setVisible(true);
    }

    protected void showPopupWithAuthor(String string, int n, int n2) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(string);
        Popup popup = popupFactory.getPopup(this, jToolTip, n, n2);
        popup.show();
        Timer timer = new Timer(5000, new HidePopupManagement(popup));
        timer.setRepeats(false);
        timer.start();
    }

    public Font getCurrentFont() {
        return new Font(this.fontFamily, this.fontStyle, this.fontSize);
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public Color getFontBackgroundColor() {
        return this.fontBackgroundColor;
    }

    public void setFontBackgroundColor(Color color) {
        this.fontBackgroundColor = color;
    }

    public Color getFontForegroundColor() {
        return this.fontForegroundColor;
    }

    public void setFontForegroundColor(Color color) {
        this.fontForegroundColor = color;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
    }

    public void setCurrentTransparency(int n) {
        this.currentTransparency = n;
        Color color = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), n);
        this.setCurrentColor(color);
    }

    public int getCurrentTransparency() {
        return this.currentTransparency;
    }

    public Color getSelectionBackgroundColor() {
        return this.SELECTION_BACKGROUND_COLOR;
    }

    public Color getCurrentBackgroundColor() {
        return this.currentBackgroundColor;
    }

    public void setCurrentBackgroundColor(Color color) {
        this.currentBackgroundColor = color;
        this.setBackground(this.currentBackgroundColor);
    }

    public Point2D.Double scaleToZeroOne(Point point) {
        Dimension dimension = this.getSize();
        double d = (double)point.x / (double)dimension.width;
        double d2 = (double)point.y / (double)dimension.height;
        return new Point2D.Double(d, d2);
    }

    class HidePopupManagement
    implements ActionListener {
        Popup popup;

        public HidePopupManagement(Popup popup) {
            this.popup = popup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.popup.hide();
        }
    }

    class PictureChangeListener
    implements ActionListener {
        PictureChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Board.this.chat.showWindow();
            if (actionEvent != null) {
                switch (actionEvent.getID()) {
                    case 1: {
                        this.displayAuthor(actionEvent);
                        break;
                    }
                }
            }
            Board.this.repaint();
        }

        private void displayAuthor(ActionEvent actionEvent) {
            String[] stringArray = actionEvent.getActionCommand().split("\\s");
            String string = stringArray[0];
            if (!string.equals(Board.this.chat.getMyJID().toString())) {
                double d = Double.parseDouble(stringArray[1]);
                double d2 = Double.parseDouble(stringArray[2]);
                Point point = this.scaleToNormalSize(new Point2D.Double(d, d2));
                int n = point.x + Board.this.getLocationOnScreen().x;
                int n2 = point.y + Board.this.getLocationOnScreen().y;
                JID jID = null;
                try {
                    jID = JID.checkedJIDFromString((String)string);
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                JIDStatus jIDStatus = Roster.getJIDStatus((JID)jID);
                String string2 = jIDStatus == null ? string : jIDStatus.getNick();
                Board.this.showPopupWithAuthor(string2, n, n2);
            }
        }

        private Point scaleToNormalSize(Point2D.Double double_) {
            Dimension dimension = Board.this.getSize();
            int n = (int)(double_.x * (double)dimension.width);
            int n2 = (int)(double_.y * (double)dimension.height);
            return new Point(n, n2);
        }
    }

    class MouseMotionL
    implements MouseMotionListener {
        MouseMotionL() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point2D.Double double_ = Board.this.scaleToZeroOne(mouseEvent.getPoint());
            Board.this.currentMode.mouseDragged(double_);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point2D.Double double_ = Board.this.scaleToZeroOne(mouseEvent.getPoint());
            Board.this.currentMode.mouseMoved(double_);
        }
    }

    class MouseL
    implements MouseListener {
        MouseL() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point2D.Double double_ = Board.this.scaleToZeroOne(mouseEvent.getPoint());
            Dimension dimension = Board.this.getSize();
            Board.this.currentMode.mouseClicked(mouseEvent, Board.this.currentColor, double_, dimension.width, dimension.height);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point2D.Double double_ = Board.this.scaleToZeroOne(mouseEvent.getPoint());
            Dimension dimension = Board.this.getSize();
            Board.this.currentMode.mousePressed(double_, Board.this.currentColor, dimension.width, dimension.height);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point2D.Double double_ = Board.this.scaleToZeroOne(mouseEvent.getPoint());
            Dimension dimension = Board.this.getSize();
            Board.this.currentMode.mouseReleased(double_, dimension.width, dimension.height);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

