/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Dimension;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.shapes.actions.Action;
import nu.fw.jeti.plugins.drawing.shapes.actions.ActionPriorityStack;
import nu.fw.jeti.plugins.drawing.shapes.actions.Creation;
import nu.fw.jeti.plugins.drawing.shapes.actions.Translation;
import nu.fw.jeti.plugins.drawing.ui.OneHistoryPicturePanel;
import nu.fw.jeti.plugins.drawing.ui.SelectUsersToHistoryAction;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;
import nu.fw.jeti.util.I18N;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryPanel
extends JPanel {
    private PictureChat chat;
    private PicturesContent currentPicture;
    private OneHistoryPicturePanel currentPanel;
    private JPanel mainPanel;
    private JScrollPane scrollPane;
    private List<OneHistoryPicturePanel> panelList;
    private ActionPriorityStack actions;
    private int mode = 1;
    private int actionsCounter;
    private Set<UserRepresentation> displayedUsers;
    private static final int ACTIONS_NUMBER_MODE = 1;
    private static final int TIME_MODE = 2;
    private int ACTIONS_NUMBER = 5;
    private int SECONDS = 60;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 2);
    private static final long serialVersionUID = 4671029090794820300L;

    public HistoryPanel(PictureChat pictureChat) {
        this.chat = pictureChat;
        this.actions = new ActionPriorityStack();
        this.currentPicture = new PicturesContent();
        this.panelList = new ArrayList<OneHistoryPicturePanel>();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.createScrollPane();
        this.add(this.scrollPane);
        this.addSelectUsersToHistoryButton();
        this.hideHistory();
    }

    private void addSelectUsersToHistoryButton() {
        SelectUsersToHistoryAction selectUsersToHistoryAction = new SelectUsersToHistoryAction(new StringBuffer().append("<html><center>").append(I18N.getText((String)"drawing", (String)"Display")).append("<br>").append(I18N.getText((String)"drawing", (String)"selected_users")).toString(), null, I18N.getText((String)"drawing", (String)"Display_in_history_only_selected_users"), null, this.chat, this);
        this.add(new JButton(selectUsersToHistoryAction));
    }

    private void createScrollPane() {
        this.scrollPane = new JScrollPane(this.mainPanel){

            public Dimension getPreferredSize() {
                return new Dimension(170, 425);
            }
        };
    }

    public void showHistory() {
        this.setVisible(true);
    }

    public void hideHistory() {
        this.setVisible(false);
    }

    public void addAction(Action action) {
        this.actions.add(action, this.currentPicture);
        this.changePicture(action);
        this.increaseActionsCounter(action);
        this.mainPanel.repaint();
        this.repaint();
    }

    private void increaseActionsCounter(Action action) {
        if (this.isNotCreation(action)) {
            ++this.actionsCounter;
        }
    }

    private boolean isNotCreation(Action action) {
        return !(action instanceof Creation);
    }

    private boolean isNotTranslation(Action action) {
        return !(action instanceof Translation);
    }

    private void changePicture(Action action) {
        switch (this.mode) {
            case 1: {
                if (this.actionsCounter % this.ACTIONS_NUMBER == 0 && this.isNotCreation(action)) {
                    this.createNewPanel(action);
                }
                this.executeAction(action);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private String getTime(Action action) {
        String string = action.getTime();
        return action.getTime();
    }

    private void executeAction(Action action) {
        if (this.isNotTranslation(action)) {
            action.execute(this.currentPicture);
        }
        if (this.isNotCreation(action)) {
            this.currentPanel.changeFrameTitle(this.getTime(action));
        }
    }

    private void createNewPanel(Action action) {
        String string = this.getTime(action);
        PicturesContent picturesContent = this.copyCurrentPicture();
        if (this.currentPanel != null) {
            this.currentPanel.setPicture(picturesContent);
        }
        this.currentPanel = new OneHistoryPicturePanel(this.currentPicture, string, this.displayedUsers);
        this.panelList.add(this.currentPanel);
        this.mainPanel.add(this.currentPanel);
        this.scrollPane.revalidate();
    }

    private PicturesContent copyCurrentPicture() {
        return this.currentPicture.copy();
    }

    private void clearPanel() {
        this.scrollPane.removeAll();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(170, 480);
    }

    public void selectUsersToDisplay(Set<UserRepresentation> set) {
        if (!set.isEmpty()) {
            this.displayedUsers = set;
            for (OneHistoryPicturePanel oneHistoryPicturePanel : this.panelList) {
                oneHistoryPicturePanel.setDisplayAuthors(set);
                oneHistoryPicturePanel.repaint();
            }
            this.scrollPane.revalidate();
        }
    }
}

