/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.ImageIcon;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.Polygon;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.Mode;

public class PolygonMode
extends Mode {
    private Vector<Point2D.Double> points = new Vector();
    private boolean isFilled;

    public PolygonMode(PictureChat pictureChat, Board board, String string, ImageIcon imageIcon, String string2, Integer n, boolean bl) {
        super(pictureChat, board, string, imageIcon, string2, n);
        this.isFilled = bl;
        this.points = new Vector();
    }

    public void dispose() {
        super.dispose();
        this.points.clear();
    }

    public void mouseClicked(MouseEvent mouseEvent, Color color, Point2D.Double double_, int n, int n2) {
        this.color = color;
        this.chat.unselect();
        if (mouseEvent.getClickCount() == 2 || mouseEvent.getButton() == 3) {
            if (this.points.size() > 0) {
                if (this.points.size() - 1 > 0 && mouseEvent.getButton() == 3) {
                    this.points.remove(this.points.size() - 1);
                }
                Polygon polygon = new Polygon(this.points, this.color, this.chat.getMyJID(), this.isFilled);
                this.chat.draw(polygon);
                this.board.setCurrentShape(null);
                this.points.clear();
            }
        } else {
            if (this.points.isEmpty()) {
                this.end = double_;
                this.points.add(this.end);
            }
            this.points.add(this.end);
        }
        this.board.repaint();
    }

    public void mouseMoved(Point2D.Double double_) {
        if (!this.points.isEmpty()) {
            this.end = double_;
            this.points.setElementAt(this.end, this.points.size() - 1);
            if (this.board.getCurrentShape() != null) {
                this.board.getCurrentShape().setCoordinates(PointsOperations.pointsToString(this.points));
            } else {
                this.board.setCurrentShape(new Polygon(this.points, this.color, this.chat.getMyJID(), this.isFilled));
            }
            this.board.repaint();
        }
    }
}

