/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.demo;

import java.awt.Component;
import java.util.Iterator;
import java.util.Vector;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mil.jfcom.cie.media.demo.DemoJFrame;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.session.StreamPlayer;

public class GUISessionHandler
implements MediaSessionListener {
    DemoJFrame main;
    JPanel playerPanel;
    JLabel userLabel;

    GUISessionHandler(DemoJFrame main, JPanel playerPanel, JLabel userLabel) {
        this.main = main;
        this.playerPanel = playerPanel;
        this.userLabel = userLabel;
    }

    public void newStreamIdentified(StreamPlayer streamPlayer) {
        final Component playerComp = streamPlayer.getPlayer().getControlPanelComponent();
        if (!this.findPlayerGui(playerComp)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUISessionHandler.this.playerPanel.add(playerComp, "Center");
                    GUISessionHandler.this.playerPanel.validate();
                }
            });
        }
        this.updateUserInfo(streamPlayer.getSourceDescription());
    }

    public void senderReportReceived(SenderReport report) {
        this.updateUserInfo(report.getSourceDescription());
    }

    public void streamClosed(StreamPlayer streamPlayer, boolean timeout) {
        final Component playerComp = streamPlayer.getPlayer().getControlPanelComponent();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUISessionHandler.this.setUserInfo("");
                GUISessionHandler.this.playerPanel.remove(playerComp);
                GUISessionHandler.this.playerPanel.validate();
                GUISessionHandler.this.main.disconnect();
            }
        });
    }

    private boolean findPlayerGui(Component playerComponent) {
        Component[] components = this.playerPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != playerComponent) continue;
            return true;
        }
        return false;
    }

    void setUserInfo(final String label) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUISessionHandler.this.userLabel.setText(label);
            }
        });
    }

    private void updateUserInfo(Vector sourceDescription) {
        String userInfo = "Unknow User";
        Iterator iter = sourceDescription.iterator();
        while (iter.hasNext()) {
            SourceDescription desc = (SourceDescription)iter.next();
            if (desc.getType() != 1) continue;
            userInfo = desc.getDescription();
        }
        String label = userInfo;
        this.setUserInfo(label);
    }
}

