/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.ControllerAdapter;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.StartEvent;
import javax.media.protocol.DataSource;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.SenderReport;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.session.StreamPlayer;
import mil.jfcom.cie.media.srtp.Logging;

class RTPEventHandler
implements ReceiveStreamListener,
RemoteListener {
    private MediaSessionListener listener;
    private Map streams = new HashMap();

    RTPEventHandler() {
    }

    public void close() {
        Iterator iter = this.streams.values().iterator();
        while (iter.hasNext()) {
            Player player = ((StreamPlayer)iter.next()).getPlayer();
            try {
                player.stop();
                player.deallocate();
                player.close();
            }
            catch (Exception e) {
                Logging.LOG.error((Object)"Closing media player", (Throwable)e);
            }
        }
        this.streams.clear();
    }

    public Collection getRemoteStreamPlayers() {
        return new ArrayList(this.streams.values());
    }

    public void setListener(MediaSessionListener listener) {
        this.listener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(ReceiveStreamEvent event) {
        ReceiveStream stream = event.getReceiveStream();
        if (event instanceof NewReceiveStreamEvent || event instanceof StreamMappedEvent || event instanceof ActiveReceiveStreamEvent) {
            if (stream.getDataSource() == null) return;
            try {
                StreamPlayer streamPlayer = this.getStreamPlayer(stream);
                if (stream.getParticipant() == null || this.listener == null) return;
                this.listener.newStreamIdentified(streamPlayer);
                return;
            }
            catch (Exception e) {
                Logging.LOG.error((Object)("Opening player for " + event.getClass().getName()), (Throwable)e);
                return;
            }
        } else {
            if (!(event instanceof InactiveReceiveStreamEvent) && !(event instanceof TimeoutEvent)) return;
            this.removeStream(stream, !(event instanceof ByeEvent));
        }
    }

    public void update(RemoteEvent evt) {
        if (this.listener != null && evt instanceof SenderReportEvent) {
            SenderReportEvent event = (SenderReportEvent)evt;
            SenderReport report = event.getReport();
            try {
                report.getSourceDescription();
                this.listener.senderReportReceived(report);
            }
            catch (NullPointerException e) {
                Logging.LOG.trace((Object)"No source desc. Skip report.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamPlayer getStreamPlayer(ReceiveStream stream) throws NoPlayerException, IOException {
        StreamPlayer streamPlayer = (StreamPlayer)this.streams.get(stream);
        if (streamPlayer == null) {
            DataSource dsource = stream.getDataSource();
            final Player newplayer = Manager.createPlayer((DataSource)dsource);
            newplayer.addControllerListener((ControllerListener)new ControllerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void start(StartEvent evt) {
                    Object source = evt.getSource();
                    Player player = newplayer;
                    synchronized (player) {
                        source.notify();
                    }
                }
            });
            newplayer.start();
            streamPlayer = new StreamPlayer(newplayer, stream);
            this.streams.put(stream, streamPlayer);
            Player player = newplayer;
            synchronized (player) {
                while (newplayer.getState() < 300) {
                    try {
                        newplayer.wait();
                    }
                    catch (InterruptedException e) {
                        Logging.LOG.debug((Object)"wait() interrupted starting new player", (Throwable)e);
                    }
                }
            }
        }
        return streamPlayer;
    }

    private void removeStream(ReceiveStream stream, boolean timeout) {
        StreamPlayer streamPlayer = (StreamPlayer)this.streams.remove(stream);
        if (streamPlayer != null) {
            Player player;
            if (this.listener != null) {
                this.listener.streamClosed(streamPlayer, timeout);
            }
            if ((player = streamPlayer.getPlayer()).getState() == 600) {
                player.stop();
                player.deallocate();
                player.close();
            }
        }
    }
}

