/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import mil.jfcom.cie.media.srtp.BaseProcessor;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.RTPTransport;

public class SRTPTransport
extends RTPTransport {
    private BaseProcessor receiveProcessor;
    private BaseProcessor sendProcessor;
    private long lastTime;
    private long srtp;
    private long ipudp;
    private long payload;

    public SRTPTransport(DatagramSocket localSocket, InetAddress remoteAddress, int remotePort) {
        super(localSocket, remoteAddress, remotePort);
        this.lastTime = -(localSocket.getLocalPort() % 2);
    }

    public void close() {
        super.close();
        this.receiveProcessor = null;
        this.sendProcessor = null;
    }

    public int read(byte[] data, int offset, int maxLength) {
        int length;
        try {
            length = this.receiveProcessor.process(this.recvBuf, this.receivePacket.getOffset(), this.receivePacket.getLength(), data, offset);
        }
        catch (GeneralSecurityException e) {
            Logging.LOG.debug((Object)"SRTP receive", (Throwable)e);
            return 0;
        }
        return length;
    }

    public void start(BaseProcessor sendProc, BaseProcessor receiveProc) {
        this.receiveProcessor = receiveProc;
        this.sendProcessor = sendProc;
        super.start(null, null);
    }

    public int write(byte[] data, int offset, int inputLength) {
        int length;
        byte[] buffer = new byte[inputLength + 100];
        try {
            length = this.sendProcessor.process(data, offset, inputLength, buffer, 0);
        }
        catch (GeneralSecurityException e) {
            Logging.LOG.debug((Object)"SRTP send", (Throwable)e);
            return 0;
        }
        catch (NullPointerException e) {
            return 0;
        }
        try {
            this.sock.send(new DatagramPacket(buffer, 0, length, this.remoteAddress, this.remotePort));
            if (this.lastTime >= 0L) {
                this.payload += (long)(length - 22);
                this.srtp += 22L;
                this.ipudp += 28L;
                long now = System.currentTimeMillis();
                if (this.lastTime == 0L) {
                    this.lastTime = now;
                } else {
                    long interval = now - this.lastTime;
                    if (interval >= 3000L) {
                        this.lastTime = now;
                        long br = this.payload * 8L * 1000L / interval;
                        long ipbr = this.ipudp * 8L * 1000L / interval;
                        long srbr = this.srtp * 8L * 1000L / interval;
                        this.payload = 0L;
                        this.srtp = 0L;
                        this.ipudp = 0L;
                        Logging.LOG.info((Object)("Payload: " + br + " bps + IP/UDP: " + ipbr + " bps + S/RTP: " + srbr + " bps = " + (br + ipbr + srbr) + " bps (interval " + interval + " ms)"));
                    }
                }
            }
            return length;
        }
        catch (SocketException e) {
            Logging.LOG.debug((Object)"Socket already closed", (Throwable)e);
        }
        catch (IOException e) {
            Logging.LOG.error((Object)"UDP send", (Throwable)e);
        }
        return 0;
    }
}

