/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.messagelog;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.events.ChatEndedListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.OwnMessageListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.messagelog.MessageLogWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class Plugin
implements MessageListener,
StatusChangeListener,
OwnMessageListener,
ChatEndedListener,
Plugins {
    public static final String NAME = "messagelog";
    public static final String VERSION = "2.0";
    public static final String DESCRIPTION = "messagelog.message_logger";
    public static final String MIN_JETI_VERSION = "0.5.4";
    public static final String ABOUT = "by E.S. de Boer";
    private Map openStreamJIDS = new HashMap();
    private Date date = new Date();
    private DateFormat dateFormat;
    private static Plugin plugin;

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public Plugin(Backend backend) {
        File file = new File(Start.path + "logs" + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        backend.getMain().addToRosterMenu(I18N.gettext((String)"messagelog.Show_MessageLog"), new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                new MessageLogWindow(jIDStatus, jIDStatusGroup);
            }
        });
        backend.addListener(MessageListener.class, (JETIListener)this);
        backend.addListener(OwnMessageListener.class, (JETIListener)this);
        backend.addListener(StatusChangeListener.class, (JETIListener)this);
        backend.addListener(ChatEndedListener.class, (JETIListener)this);
        this.dateFormat = DateFormat.getTimeInstance();
    }

    public void unload() {
        this.exit();
    }

    public static void unload(Backend backend) {
        backend.removeListener(MessageListener.class, (JETIListener)plugin);
        backend.removeListener(OwnMessageListener.class, (JETIListener)plugin);
        backend.removeListener(StatusChangeListener.class, (JETIListener)plugin);
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)"messagelog.Show_MessageLog"));
    }

    public synchronized void message(Message message) {
        this.add(message);
    }

    public synchronized void sendMessage(Message message) {
        this.date.setTime(System.currentTimeMillis());
        PrintWriter printWriter = this.getLog(message.getTo());
        if (printWriter != null) {
            printWriter.println(this.dateFormat.format(this.date) + " " + I18N.gettext((String)"messagelog.I_say") + " " + message.getBody());
        }
    }

    private void add(Message message) {
        this.date.setTime(System.currentTimeMillis());
        JID jID = message.getFrom();
        PrintWriter printWriter = this.getLog(jID);
        if (printWriter == null) {
            return;
        }
        if (message.getType().equals("error")) {
            printWriter.println(this.dateFormat.format(this.date) + " " + I18N.gettext((String)"main.error.Error_in_chat") + " " + message.getBody());
        } else {
            String string = jID.getUser();
            if (message.getType().equals("groupchat")) {
                string = jID.getResource();
            } else {
                JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID);
                if (jIDStatus != null) {
                    string = jIDStatus.getNick();
                }
            }
            printWriter.println(this.dateFormat.format(this.date) + " " + string + " " + I18N.gettext((String)"messagelog.says") + " " + message.getBody());
        }
    }

    private PrintWriter getLog(JID jID) {
        PrintWriter printWriter = null;
        if (this.openStreamJIDS.containsKey(jID)) {
            Object v = this.openStreamJIDS.get(jID);
            if (v instanceof String) {
                return null;
            }
            printWriter = (PrintWriter)v;
        } else {
            String string = null;
            JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID);
            string = jIDStatus != null ? (jIDStatus.getType().equals("unknown") || jIDStatus.getType().equals("jabber") ? jID.toStringNoResource() : jID.getUser() + "." + jIDStatus.getType()) : jID.toStringNoResource();
            String string2 = Start.path + "logs" + File.separator + string + ".txt";
            try {
                printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string2, true)), true);
            }
            catch (IOException iOException) {
                Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"messagelog.{0}_could_not_be_opened_in_write_mode"), string2), (String)I18N.gettext((String)"messagelog.Logfile_Error"));
                this.openStreamJIDS.put(jID, "");
                return null;
            }
            this.openStreamJIDS.put(jID, printWriter);
            printWriter.println();
            printWriter.println("----------------" + this.date.toString() + "----------------");
            printWriter.println();
        }
        return printWriter;
    }

    public void chatEnded(JID jID) {
        PrintWriter printWriter = (PrintWriter)this.openStreamJIDS.remove(jID);
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public void connectionChanged(boolean bl) {
        if (!bl) {
            this.exit();
        }
    }

    public void exit() {
        Iterator iterator = this.openStreamJIDS.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof String) continue;
            ((PrintWriter)v).close();
        }
        this.openStreamJIDS.clear();
    }

    public void ownPresenceChanged(int n, String string) {
    }
}

