/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.alertwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.NativeUtils;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
extends JWindow
implements PresenceListener,
MessageListener,
Plugins {
    public static final String VERSION = "2.0";
    public static final String DESCRIPTION = "alertwindow.Shows_an_alert_window_when_a_message_arrives";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "alertwindow";
    public static final String ABOUT = "by E.S. de Boer";
    public static final String PARENT = "Notifiers";
    private JLabel lblName;
    private JLabel label;
    private JLabel icon;
    private Timer timer = new Timer(true);
    private TimerTask tt;
    private int time;
    private static Plugin plugin;
    private NativeUtils util;
    private static Point pntLowerRight;
    private int alpha;
    private Avatars avatars;
    static boolean supportsAlpha;
    private Color[] colors = new Color[5];
    private static final int MESSAGE = 0;
    private static final int ONLINE = 1;
    private static final int OFFLINE = 2;
    private static final int AWAY = 3;
    private static final int DND = 4;

    public Plugin() {
        super((Window)null);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.icon = new JLabel();
        this.icon.setOpaque(true);
        this.getContentPane().add((Component)this.icon, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 1);
        gridBagConstraints.gridheight = 1;
        this.lblName = new JLabel();
        this.lblName.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.lblName.setOpaque(true);
        this.lblName.setFont((Font)UIManager.get("TextArea.font"));
        this.getContentPane().add((Component)this.lblName, gridBagConstraints);
        this.label = new JLabel();
        this.label.setBorder(new EmptyBorder(0, 4, 4, 4));
        this.label.setOpaque(true);
        this.label.setFont((Font)UIManager.get("TextArea.font"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 1);
        this.getContentPane().add((Component)this.label, gridBagConstraints);
        this.enableInputMethods(false);
        this.setSize(1, 1);
        this.setVisible(true);
        this.setFocusableWindowState(false);
        this.setFocusable(false);
        int n = Preferences.getInteger((String)NAME, (String)"XOffset", (int)0);
        int n2 = Preferences.getInteger((String)NAME, (String)"YOffset", (int)0);
        this.caculateLowerRightPoint(n, n2);
    }

    public static void init(Backend backend) {
        plugin = new Plugin();
        plugin.initColors();
        backend.addListener(MessageListener.class, (JETIListener)plugin);
        backend.addListener(PresenceListener.class, (JETIListener)plugin);
        Color color = new Color(Preferences.getInteger((String)NAME, (String)"foregroundcolor", (int)SystemColor.controlText.getRGB()));
        Plugin.plugin.label.setForeground(color);
        Plugin.plugin.lblName.setForeground(color);
        Plugin.plugin.time = Preferences.getInteger((String)NAME, (String)"popuptime", (int)5) * 1000;
    }

    private void initColors() {
        Plugin.plugin.colors[0] = new Color(Preferences.getInteger((String)NAME, (String)"message.backgroundcolor", (int)SystemColor.info.getRGB()));
        Plugin.plugin.colors[1] = new Color(Preferences.getInteger((String)NAME, (String)"online.backgroundcolor", (int)Color.GREEN.getRGB()));
        Plugin.plugin.colors[2] = new Color(Preferences.getInteger((String)NAME, (String)"offline.backgroundcolor", (int)Color.GRAY.getRGB()));
        Plugin.plugin.colors[3] = new Color(Preferences.getInteger((String)NAME, (String)"away.backgroundcolor", (int)Color.RED.getRGB()));
        Plugin.plugin.colors[4] = new Color(Preferences.getInteger((String)NAME, (String)"do_not_disturb.backgroundcolor", (int)Color.ORANGE.getRGB()));
    }

    private void loadWindowsUtils() {
        if (this.util == null) {
            if (PluginsInfo.isPluginLoaded((String)"windowsutils")) {
                this.util = (NativeUtils)PluginsInfo.newPluginInstance((String)"windowsutils");
                supportsAlpha = this.util.supportsAlpha();
                if (this.util != null) {
                    try {
                        if (System.getProperty("java.version").indexOf("1.5") == -1) {
                            this.util.windowAlwaysOnTop((Component)plugin, true);
                        }
                        if (supportsAlpha) {
                            this.alpha = Preferences.getInteger((String)NAME, (String)"alpha", (int)100);
                            if (this.alpha < 100) {
                                this.util.setWindowAlpha((Component)plugin, this.alpha);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        } else if (System.getProperty("os.name").equals("OS/2")) {
            this.util.windowAlwaysOnTop((Component)plugin, true);
        }
    }

    public void unload() {
        if (this.util != null) {
            try {
                if (this.util.supportsAlpha()) {
                    this.util.setWindowAlpha((Component)this, 0);
                }
                this.util.windowAlwaysOnTop((Component)this, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dispose();
    }

    public static void unload(Backend backend) {
        backend.removeListener(MessageListener.class, (JETIListener)plugin);
        backend.removeListener(PresenceListener.class, (JETIListener)plugin);
        plugin.unload();
        plugin = null;
    }

    private Avatars getAvatar() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded((String)"ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance((String)"ichatavatars");
            return this.avatars;
        }
        return null;
    }

    public void presenceChanged(final Presence presence) {
        this.loadWindowsUtils();
        Runnable runnable = new Runnable(){

            public void run() {
                if (presence.getShow() == 7) {
                    if (!Preferences.getBoolean((String)Plugin.NAME, (String)"offline.enabled", (boolean)true)) {
                        return;
                    }
                    Plugin.this.setBackgroundColor(Plugin.this.colors[2]);
                } else if (presence.getShow() == 2 || presence.getShow() == 1) {
                    if (!Preferences.getBoolean((String)Plugin.NAME, (String)"online.enabled", (boolean)true)) {
                        return;
                    }
                    Plugin.this.setBackgroundColor(Plugin.this.colors[1]);
                } else if (presence.getShow() == 4) {
                    if (!Preferences.getBoolean((String)Plugin.NAME, (String)"dnd.enabled", (boolean)true)) {
                        return;
                    }
                    Plugin.this.setBackgroundColor(Plugin.this.colors[4]);
                } else {
                    if (!Preferences.getBoolean((String)Plugin.NAME, (String)"away.enabled", (boolean)true)) {
                        return;
                    }
                    Plugin.this.setBackgroundColor(Plugin.this.colors[3]);
                }
                Plugin.this.setIcon(presence.getFrom());
                Plugin.this.lblName.setText(Plugin.this.getNick(presence.getFrom()));
                String string = presence.getStatus();
                if (string == null) {
                    string = Presence.toLongShow((int)presence.getShow());
                }
                Plugin.this.label.setText(string);
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void message(final Message message) {
        if (!Preferences.getBoolean((String)NAME, (String)"message.enabled", (boolean)true)) {
            return;
        }
        this.loadWindowsUtils();
        Runnable runnable = new Runnable(){

            public void run() {
                Plugin.this.setBackgroundColor(Plugin.this.colors[0]);
                JID jID = message.getFrom();
                Plugin.this.setIcon(jID);
                String string = message.getType().equals("groupchat") ? jID.getResource() : Plugin.this.getNick(jID);
                Plugin.this.lblName.setText(string);
                Plugin.this.label.setText(message.getBody());
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private synchronized void setIcon(JID jID) {
        ImageIcon imageIcon;
        JIDStatus jIDStatus;
        this.icon.setIcon(null);
        Avatars avatars = this.getAvatar();
        if (avatars != null && (jIDStatus = Backend.getJIDStatus((JID)jID)) != null && (imageIcon = jIDStatus.getAvatar()) != null) {
            if (imageIcon.getIconHeight() > 64 || imageIcon.getIconWidth() > 64) {
                imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(64, 64, 1));
            }
            this.icon.setIcon(imageIcon);
        }
    }

    private String getNick(JID jID) {
        String string = jID.getUser();
        JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID);
        if (jIDStatus != null) {
            string = jIDStatus.getNick();
        }
        return string;
    }

    private void setBackgroundColor(Color color) {
        Plugin.plugin.label.setBackground(color);
        Plugin.plugin.lblName.setBackground(color);
        Plugin.plugin.icon.setBackground(color);
    }

    public void demo(Color color, Color color2, final int n, final int n2, int n3, int n4) {
        this.initColors();
        this.time = n2 * 1000;
        this.label.setBackground(color);
        this.lblName.setBackground(color);
        this.icon.setBackground(color);
        this.label.setForeground(color2);
        this.lblName.setForeground(color2);
        Plugin.plugin.time = this.time;
        this.setBackgroundColor(color);
        Plugin.plugin.label.setForeground(color2);
        Plugin.plugin.lblName.setForeground(color2);
        Plugin.plugin.alpha = n;
        this.loadWindowsUtils();
        this.caculateLowerRightPoint(n3, n4);
        if (this.util != null && supportsAlpha) {
            try {
                this.util.setWindowAlpha((Component)this, n);
                this.util.setWindowAlpha((Component)plugin, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Plugin.this.lblName.setText(I18N.gettext((String)"alertwindow.This_is_a_Demonstration_PopupWindow"));
                Plugin.this.label.setText(MessageFormat.format(I18N.gettext((String)"alertwindow.Alpha_is_{0},_Time_is_{1}"), String.valueOf(n), String.valueOf(n2)));
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void caculateLowerRightPoint(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        pntLowerRight = new Point(rectangle.x + rectangle.width - n, rectangle.y + rectangle.height - n2);
    }

    private void place() {
        if (this.tt != null) {
            this.tt.cancel();
        }
        this.tt = new TimerTask(){

            public void run() {
                Plugin.this.setSize(1, 1);
                Plugin.this.setLocation(pntLowerRight);
                if (Plugin.this.util != null && supportsAlpha && Plugin.this.alpha < 100) {
                    try {
                        Plugin.this.util.setWindowAlpha((Component)Plugin.this, 100);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        };
        this.pack();
        this.setLocation(Plugin.pntLowerRight.x - this.getWidth(), Plugin.pntLowerRight.y - this.getHeight());
        this.timer.schedule(this.tt, this.time);
        if (this.util != null && supportsAlpha && this.alpha < 100) {
            try {
                this.util.setWindowAlpha((Component)this, this.alpha);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (System.getProperty("java.version").indexOf("1.5") != -1) {
            this.setAlwaysOnTop(true);
        }
    }
}

