/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchatalerter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.groupchat.elements.XMUC;
import nu.fw.jeti.plugins.groupchatalerter.Alerter;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
StatusChangeListener {
    public static final String NAME = "groupchatalerter";
    public static final String VERSION = "1.0";
    public static final String DESCRIPTION = "groupchatalerter.Alerts_you_when_there_is_something_interesting";
    public static final String MIN_JETI_VERSION = "0.6.7";
    public static final String ABOUT = "by E.S. de Boer";
    public static final int ALERTERS_SIZE = 6;
    private static Plugin plugin;
    private Map alerters = new HashMap();
    private Backend backend;
    private boolean away = false;

    public static void init(Backend backend) {
        try {
            plugin = new Plugin(backend);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Plugin(Backend backend) {
        this.backend = backend;
        backend.addListener(StatusChangeListener.class, (JETIListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMonitoring(JID jID) {
        Map map = Plugin.plugin.alerters;
        synchronized (map) {
            return Plugin.plugin.alerters.containsKey(jID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disableAlerter(JID jID) {
        Alerter alerter = null;
        Map map = Plugin.plugin.alerters;
        synchronized (map) {
            alerter = (Alerter)Plugin.plugin.alerters.get(jID);
        }
        if (alerter != null) {
            alerter.disable();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRule(JID jID, String string) {
        Map map = Plugin.plugin.alerters;
        synchronized (map) {
            ((Alerter)Plugin.plugin.alerters.get(jID)).updateRule(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAlerter(Alerter alerter, JID jID) {
        Map map = Plugin.plugin.alerters;
        synchronized (map) {
            if (Plugin.plugin.alerters.containsKey(jID)) {
                ((Alerter)Plugin.plugin.alerters.remove(jID)).remove();
            }
            Plugin.plugin.alerters.put(jID, alerter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAlerter(JID jID) {
        Alerter alerter = null;
        Map map = Plugin.plugin.alerters;
        synchronized (map) {
            alerter = (Alerter)Plugin.plugin.alerters.remove(jID);
        }
        if (alerter != null) {
            alerter.remove();
        }
    }

    public void unload() {
        Iterator iterator = Plugin.plugin.alerters.values().iterator();
        while (iterator.hasNext()) {
            ((Alerter)iterator.next()).remove();
        }
        Plugin.plugin.alerters.clear();
        this.backend.removeListener(StatusChangeListener.class, (JETIListener)this);
    }

    public static void unload(Backend backend) {
        plugin = null;
    }

    private Avatars getAvatarInterface() {
        if (PluginsInfo.isPluginLoaded((String)"ichatavatars")) {
            return (Avatars)PluginsInfo.getPluginInstance((String)"ichatavatars");
        }
        return null;
    }

    private void sendPresence(JID jID, int n, String string) {
        Avatars avatars = this.getAvatarInterface();
        Presence presence = null;
        if (avatars != null) {
            XMUC xMUC = new XMUC();
            presence = avatars.addHash(jID, n, string, (XExtension)xMUC);
        } else {
            presence = new Presence(jID, n, string, (XExtension)new XMUC());
        }
        this.backend.send((Packet)presence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(boolean bl) {
        if (bl) {
            for (int i = 0; i < 6; ++i) {
                Object object;
                if (!Preferences.getBoolean((String)NAME, (String)("ruleEnabled" + i), (boolean)false)) continue;
                JID jID = JID.jidFromString((String)Preferences.getString((String)NAME, (String)("room" + i), null));
                if (Plugin.isMonitoring(jID)) {
                    object = this.alerters;
                    synchronized (object) {
                        jID = ((Alerter)this.alerters.get(jID)).getJID();
                        this.sendPresence(jID, 3, Preferences.getString((String)NAME, (String)"alerterStatusMessage", (String)"alerter"));
                    }
                } else {
                    object = nu.fw.jeti.plugins.groupchat.Plugin.getGroupchatJID((JID)jID);
                    if (object != null) {
                        jID = object;
                    }
                    Plugin.addAlerter(new Alerter(this.backend, jID, Preferences.getString((String)NAME, (String)("rule" + i), null)), jID);
                }
                if (!PluginsInfo.isPluginLoaded((String)"ichatavatars")) continue;
                this.sendAvatarPresence(jID);
            }
        } else {
            Map map = Plugin.plugin.alerters;
            synchronized (map) {
                Iterator iterator = this.alerters.values().iterator();
                while (iterator.hasNext()) {
                    ((Alerter)iterator.next()).offline();
                }
            }
        }
    }

    public void sendAvatarPresence(final JID jID) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                Plugin.this.sendPresence(jID, 3, Preferences.getString((String)Plugin.NAME, (String)"alerterStatusMessage", (String)"alerter"));
            }
        }, 60000L);
    }

    public void exit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ownPresenceChanged(int n, String string) {
        if (Preferences.getBoolean((String)NAME, (String)"changeStatus", (boolean)false)) {
            if (n == 4 || n == 5) {
                Map map = Plugin.plugin.alerters;
                synchronized (map) {
                    Iterator iterator = this.alerters.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        this.sendPresence((JID)entry.getKey(), n, string);
                        ((Alerter)entry.getValue()).pause(true);
                    }
                }
                this.away = true;
            } else if (this.away) {
                this.away = false;
                Map map = Plugin.plugin.alerters;
                synchronized (map) {
                    Iterator iterator = this.alerters.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        this.sendPresence((JID)entry.getKey(), 3, Preferences.getString((String)NAME, (String)"alerterStatusMessage", (String)"alerter"));
                        ((Alerter)entry.getValue()).pause(false);
                    }
                }
            }
        }
    }
}

