/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.ibb;

import java.util.HashMap;
import java.util.Map;
import nu.fw.jeti.backend.XExecutableExtension;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBReceive;
import nu.fw.jeti.util.Log;

public class IBBExtension
extends Extension
implements IQExtension,
XExecutableExtension {
    private boolean close;
    private boolean open;
    private String sid;
    private int sequence;
    private int blockSize = 4096;
    private String base64data;
    private static Map fileWindows = new HashMap(10);

    public IBBExtension(String sid, int blockSize) {
        this.open = true;
        this.blockSize = blockSize;
        this.sid = sid;
    }

    public IBBExtension(String sid) {
        this.close = true;
        this.sid = sid;
    }

    public IBBExtension(String sid, int sequence, String data) {
        this.sid = sid;
        this.sequence = sequence;
        this.base64data = data;
    }

    public IBBExtension(boolean open, boolean close, String sid, int blockSize, int sequence, String data) {
        this.open = open;
        this.close = close;
        this.sid = sid;
        this.blockSize = blockSize;
        this.sequence = sequence;
        this.base64data = data;
    }

    public String getData() {
        return this.base64data;
    }

    public String getSid() {
        return this.sid;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClose() {
        return this.close;
    }

    public void execute(Packet iq, Backend backend) {
        GetFileWindow w = (GetFileWindow)fileWindows.get(this.sid);
        if (w == null) {
            Log.xmlReceivedError((String)"ibb stream from unknown");
        } else {
            IBBReceive r = (IBBReceive)w.getStreamReceive();
            r.addData(this.getData());
        }
    }

    public void execute(InfoQuery iq, Backend backend) {
        if (iq.getType().equals("set")) {
            GetFileWindow w;
            if (this.isOpen()) {
                w = Plugin.getGetFile(iq.getFrom(), this.getSid());
                if (w != null) {
                    w.startDownloading(new IBBReceive(iq.getFrom(), this.getSid(), backend, w));
                    fileWindows.put(this.getSid(), w);
                    backend.send((Packet)new InfoQuery(iq.getFrom(), "result", iq.getID(), null));
                    Log.xmlReceivedError((String)"ibb stream init from unknown");
                } else {
                    XMPPError e = new XMPPError("cancel", 501);
                    e.addError(new XMPPErrorTag("feature-not-implemented"));
                    backend.send((Packet)new InfoQuery(iq.getFrom(), iq.getID(), e));
                }
            }
            if (this.isClose()) {
                w = (GetFileWindow)fileWindows.remove(this.sid);
                if (w != null) {
                    ((IBBReceive)w.getStreamReceive()).stopDownloading();
                }
                backend.send((Packet)new InfoQuery(iq.getFrom(), "result", iq.getID(), null));
            }
        }
    }

    public void appendToXML(StringBuffer xml) {
        if (this.open) {
            xml.append("<open xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)xml, (String)"sid", (String)this.sid);
            IBBExtension.appendAttribute((StringBuffer)xml, (String)"block-size", (String)String.valueOf(this.blockSize));
            xml.append("/>");
        } else if (this.close) {
            xml.append("<close xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)xml, (String)"sid", (String)this.sid);
            xml.append("/>");
        } else {
            xml.append("<data xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)xml, (String)"sid", (String)this.sid);
            IBBExtension.appendAttribute((StringBuffer)xml, (String)"seq", (String)String.valueOf(this.sequence));
            xml.append(">");
            xml.append(this.base64data);
            xml.append("</data>");
            xml.append("<amp xmlns='http://jabber.org/protocol/amp'>");
            xml.append("<rule condition='deliver-at' value='stored' action='error'/>");
            xml.append("<rule condition='match-resource' value='exact' action='error'/>");
            xml.append("</amp>");
        }
    }
}

