/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5.jsocks;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.ProxyMessage;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksException;

class Socks5Message
extends ProxyMessage {
    public int addrType;
    byte[] data;
    public static final int SOCKS_VERSION = 5;
    public static final int SOCKS_ATYP_IPV4 = 1;
    public static final int SOCKS_ATYP_DOMAINNAME = 3;
    public static final int SOCKS_ATYP_IPV6 = 4;
    public static final int SOCKS_IPV6_LENGTH = 16;
    static boolean doResolveIP = true;

    public Socks5Message(int cmd) {
        super(cmd, null, 0);
        this.data = new byte[3];
        this.data[0] = 5;
        this.data[1] = (byte)cmd;
        this.data[2] = 0;
    }

    public Socks5Message(int cmd, InetAddress ip, int port) {
        super(cmd, ip, port);
        byte[] addr;
        this.host = ip == null ? "0.0.0.0" : ip.getHostName();
        this.version = 5;
        if (ip == null) {
            addr = new byte[4];
            addr[3] = 0;
            addr[2] = 0;
            addr[1] = 0;
            addr[0] = 0;
        } else {
            addr = ip.getAddress();
        }
        this.addrType = addr.length == 4 ? 1 : 4;
        this.data = new byte[6 + addr.length];
        this.data[0] = 5;
        this.data[1] = (byte)this.command;
        this.data[2] = 0;
        this.data[3] = (byte)this.addrType;
        System.arraycopy(addr, 0, this.data, 4, addr.length);
        this.data[this.data.length - 2] = (byte)(port >> 8);
        this.data[this.data.length - 1] = (byte)port;
    }

    public Socks5Message(int cmd, String hostName, int port) {
        super(cmd, null, port);
        this.host = hostName;
        this.version = 5;
        this.addrType = 3;
        byte[] addr = hostName.getBytes();
        this.data = new byte[7 + addr.length];
        this.data[0] = 5;
        this.data[1] = (byte)this.command;
        this.data[2] = 0;
        this.data[3] = 3;
        this.data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, this.data, 5, addr.length);
        this.data[this.data.length - 2] = (byte)(port >> 8);
        this.data[this.data.length - 1] = (byte)port;
    }

    public Socks5Message(InputStream in) throws SocksException, IOException {
        this(in, true);
    }

    public Socks5Message(InputStream in, boolean clientMode) throws SocksException, IOException {
        this.read(in, clientMode);
    }

    public void read(InputStream in) throws SocksException, IOException {
        this.read(in, true);
    }

    public void read(InputStream in, boolean clientMode) throws SocksException, IOException {
        this.data = null;
        this.ip = null;
        DataInputStream di = new DataInputStream(in);
        this.version = di.readUnsignedByte();
        this.command = di.readUnsignedByte();
        if (clientMode && this.command != 0) {
            throw new SocksException(this.command);
        }
        int reserved = di.readUnsignedByte();
        this.addrType = di.readUnsignedByte();
        switch (this.addrType) {
            case 1: {
                byte[] addr = new byte[4];
                di.readFully(addr);
                this.host = Socks5Message.bytes2IPV4(addr, 0);
                break;
            }
            case 4: {
                byte[] addr = new byte[16];
                di.readFully(addr);
                this.host = Socks5Message.bytes2IPV6(addr, 0);
                break;
            }
            case 3: {
                byte[] addr = new byte[di.readUnsignedByte()];
                di.readFully(addr);
                this.host = new String(addr);
                break;
            }
            default: {
                throw new SocksException(393216);
            }
        }
        this.port = di.readUnsignedShort();
        if (this.addrType != 3 && doResolveIP) {
            try {
                this.ip = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void write(OutputStream out) throws SocksException, IOException {
        if (this.data == null) {
            Socks5Message msg;
            if (this.addrType == 3) {
                msg = new Socks5Message(this.command, this.host, this.port);
            } else {
                if (this.ip == null) {
                    try {
                        this.ip = InetAddress.getByName(this.host);
                    }
                    catch (UnknownHostException uh_ex) {
                        throw new SocksException(393216);
                    }
                }
                msg = new Socks5Message(this.command, this.ip, this.port);
            }
            this.data = msg.data;
        }
        out.write(this.data);
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.ip != null) {
            return this.ip;
        }
        this.ip = InetAddress.getByName(this.host);
        return this.ip;
    }

    public String toString() {
        String s = "Socks5Message:\nVN   " + this.version + "\n" + "CMD  " + this.command + "\n" + "ATYP " + this.addrType + "\n" + "ADDR " + this.host + "\n" + "PORT " + this.port + "\n";
        return s;
    }

    public static boolean resolveIP() {
        return doResolveIP;
    }

    public static boolean resolveIP(boolean doResolve) {
        boolean old = doResolveIP;
        doResolveIP = doResolve;
        return old;
    }
}

