/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Encoder;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.Stereo;

public class SpeexEncoder {
    public static final String VERSION = "Java Speex Encoder v0.9.7 ($Revision: 1.6 $)";
    private Encoder encoder;
    private Bits bits = new Bits();
    private float[] rawData;
    private int sampleRate;
    private int channels;
    private int frameSize;

    public boolean init(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                this.encoder = new NbEncoder();
                ((NbEncoder)this.encoder).nbinit();
                break;
            }
            case 1: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).wbinit();
                break;
            }
            case 2: {
                this.encoder = new SbEncoder();
                ((SbEncoder)this.encoder).uwbinit();
                break;
            }
            default: {
                return false;
            }
        }
        this.encoder.setQuality(n2);
        this.frameSize = this.encoder.getFrameSize();
        this.sampleRate = n3;
        this.channels = n4;
        this.rawData = new float[n4 * this.frameSize];
        this.bits.init();
        return true;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getProcessedData(byte[] byArray, int n) {
        int n2 = this.bits.getBufferSize();
        this.bits.insertTerminator();
        System.arraycopy(this.bits.getBuffer(), 0, byArray, n, n2);
        this.bits.init();
        return n2;
    }

    public int getProcessedDataByteSize() {
        return this.bits.getBufferSize();
    }

    public boolean processData(byte[] byArray, int n, int n2) {
        SpeexEncoder.mapPcm16bitLittleEndian2Float(byArray, n, this.rawData, 0, n2 / 2);
        return this.processData(this.rawData, n2 / 2);
    }

    public boolean processData(short[] sArray, int n, int n2) {
        int n3 = this.channels * this.frameSize;
        if (n2 != n3) {
            throw new IllegalArgumentException("SpeexEncoder requires " + n3 + " samples to process a Frame, not " + n2);
        }
        int n4 = 0;
        while (n4 < n2) {
            this.rawData[n4] = sArray[n + n4];
            ++n4;
        }
        return this.processData(this.rawData, n2);
    }

    public boolean processData(float[] fArray, int n) {
        int n2 = this.channels * this.frameSize;
        if (n != n2) {
            throw new IllegalArgumentException("SpeexEncoder requires " + n2 + " samples to process a Frame, not " + n);
        }
        if (this.channels == 2) {
            Stereo.encode(this.bits, fArray, this.frameSize);
        }
        this.encoder.encode(this.bits, fArray);
        return true;
    }

    public static void mapPcm16bitLittleEndian2Float(byte[] byArray, int n, float[] fArray, int n2, int n3) {
        if (byArray.length - n < 2 * n3) {
            throw new IllegalArgumentException("Insufficient Samples to convert to floats");
        }
        if (fArray.length - n2 < n3) {
            throw new IllegalArgumentException("Insufficient float buffer to convert the samples");
        }
        int n4 = 0;
        while (n4 < n3) {
            fArray[n2 + n4] = byArray[n + 2 * n4] & 0xFF | byArray[n + 2 * n4 + 1] << 8;
            ++n4;
        }
    }
}

