/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.spell;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class JTextComponentSpellChecker
implements SpellCheckListener {
    private SpellChecker spellCheck = null;
    private transient JTextComponent textComponent = null;

    public JTextComponentSpellChecker(SpellDictionary spellDictionary) {
        this.spellCheck = new SpellChecker(spellDictionary);
        this.spellCheck.addSpellCheckListener(this);
    }

    public synchronized int spellCheck(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(jTextComponent.getDocument());
        int n = this.spellCheck.checkSpelling(documentWordTokenizer);
        this.textComponent = null;
        return n;
    }

    public void spellingError(SpellCheckEvent spellCheckEvent) {
        int n = spellCheckEvent.getWordContextPosition();
        int n2 = n + spellCheckEvent.getInvalidWord().length();
        Painter painter = new Painter();
        try {
            this.textComponent.getHighlighter().addHighlight(n, n2, painter);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public List getSuggestions(String string) {
        return this.spellCheck.getSuggestions(string, Configuration.getConfiguration().getInteger("SPELL_THRESHOLD"));
    }

    class Painter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public Painter() {
            super(Color.RED);
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Rectangle rectangle = shape.getBounds();
            try {
                graphics.setColor(super.getColor());
                Rectangle rectangle2 = jTextComponent.modelToView(n);
                Rectangle rectangle3 = jTextComponent.modelToView(n2);
                int n3 = rectangle2.y + rectangle2.height;
                boolean bl = false;
                int n4 = 0;
                for (int i = rectangle2.x; i < rectangle3.x; ++i) {
                    n4 = bl ? ++n4 : --n4;
                    if (n4 != 0) {
                        bl = !bl;
                    }
                    graphics.drawLine(i, n3 += n4, i, n3);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return rectangle;
        }
    }
}

