/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.XMPPInputStream;
import nu.fw.jeti.plugins.PluginsInfo;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Input
extends Thread {
    private InputSource in;
    private ConnectionPacketReceiver backend;
    private JabberHandler jH;
    private boolean closing = false;

    public Input(InputStream inputStream, ConnectionPacketReceiver connectionPacketReceiver, JabberHandler jabberHandler) {
        try {
            this.in = PluginsInfo.isPluginLoaded("xmpp") ? new InputSource(new XMPPInputStream(new InputStreamReader(inputStream, "UTF-8"))) : new InputSource(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.backend = connectionPacketReceiver;
        this.jH = jabberHandler;
        this.start();
    }

    public void disconnect() {
        try {
            System.out.println("closing " + this.in.getCharacterStream());
            this.closing = true;
            this.in.getCharacterStream().close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(this.in, (DefaultHandler)this.jH);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            Exception exception = sAXParseException.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.err.println(sAXParseException.getMessage());
            }
        }
        catch (SAXException sAXException) {
            if ("end xmlparser".equals(sAXException.getMessage())) {
                this.closing = true;
                return;
            }
            Exception exception = sAXException.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.err.println(sAXException.getMessage());
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if ("end xmlparser".equals(unsupportedOperationException.getMessage())) {
                this.closing = true;
                return;
            }
            System.err.println(unsupportedOperationException.getMessage());
        }
        finally {
            System.out.println(this.in.getCharacterStream() + "closed");
            if (!this.closing) {
                this.backend.inputDeath();
            }
        }
    }
}

