/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.sound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

class PlayList
extends Thread {
    private LinkedList queue = new LinkedList();
    private volatile boolean isRunning = true;
    private Map sounds;
    private boolean singleLine = false;

    public PlayList(Map map, boolean bl) {
        this.sounds = map;
        this.singleLine = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSound(String string) {
        if (this.isRunning) {
            if (!Preferences.getBoolean((String)"sound", (String)(string + ".enabled"), (boolean)true)) {
                return;
            }
            Object v = this.sounds.get(string);
            if (!this.queue.contains(v)) {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    this.queue.addLast(v);
                    this.queue.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlaying() {
        this.isRunning = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object object;
        Clip clip = null;
        byte[] byArray = null;
        AudioFormat audioFormat = null;
        while (this.isRunning) {
            object = this.queue;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    if (this.isRunning) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            return;
                        }
                    }
                    continue;
                }
                if (this.singleLine) {
                    Object[] objectArray = (Object[])this.queue.removeFirst();
                    audioFormat = (AudioFormat)objectArray[0];
                    byArray = (byte[])objectArray[1];
                } else {
                    clip = (Clip)this.queue.removeFirst();
                }
            }
            if (this.singleLine) {
                this.playSingleLine(byArray, audioFormat);
                continue;
            }
            clip.setFramePosition(0);
            if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                object = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                float f = Preferences.getInteger((String)"sound", (String)"volume", (int)0);
                if (f > ((FloatControl)object).getMaximum()) {
                    f = ((FloatControl)object).getMaximum();
                }
                ((FloatControl)object).setValue(f);
            }
            clip.start();
        }
        if (!this.singleLine) {
            object = this.queue.iterator();
            while (object.hasNext()) {
                ((Clip)object.next()).close();
            }
        }
    }

    private void playSingleLine(byte[] byArray, AudioFormat audioFormat) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray.length / audioFormat.getFrameSize());
        Line.Info info = new Line.Info(Clip.class);
        Clip clip = null;
        try {
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println(I18N.gettext((String)"sound.Problem_playing_sound_check_your_sound_system"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            float f = Preferences.getInteger((String)"sound", (String)"volume", (int)0);
            if (f > floatControl.getMaximum()) {
                f = floatControl.getMaximum();
            }
            floatControl.setValue(f);
        }
        clip.start();
        try {
            PlayList.sleep(clip.getMicrosecondLength() / 1000L);
            clip.stop();
            clip.close();
            clip = null;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

