/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.systemtray;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.ui.Jeti;
import nu.fw.jeti.ui.RegisterServices;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.ui.login.LoginWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class Plugin
implements ActionListener,
StatusChangeListener,
Plugins {
    private Jeti main;
    private TrayIcon trayIcon;
    private Backend backend;
    private int status;
    public static final String VERSION = "2.0";
    public static final String DESCRIPTION = "systemtray.shows_system_tray_icon";
    public static final String MIN_JETI_VERSION = "0.5";
    public static final String NAME = "systemtray";
    public static final String ABOUT = "by E.S. de boer, uses TrayIcon from JDIC";
    private static Plugin plugin;

    public static void init(Backend backend) {
        Plugin.addDir(Start.path);
        PluginsInfo.loadLibrary((String)"jdic");
        if (System.getProperty("os.name").startsWith("Windows")) {
            PluginsInfo.loadLibrary((String)"jdic_win");
        } else {
            PluginsInfo.loadLibrary((String)"jdic_stub");
        }
        plugin = new Plugin(backend);
    }

    public static void addDir(String string) {
        try {
            String string2 = string + File.pathSeparator + System.getProperty("java.library.path");
            System.out.println(string2);
            System.setProperty("java.library.path", string2);
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            if (field != null) {
                field.setAccessible(true);
                field.set(System.class.getClassLoader(), null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Plugin(Backend backend) {
        this.main = backend.getMain();
        this.backend = backend;
        this.trayIcon = new TrayIcon((Icon)StatusIcons.getOfflineIcon(), "Jeti", this.makeMenu());
        this.trayIcon.setIconAutoSize(true);
        this.trayIcon.addActionListener((ActionListener)this);
        SystemTray.getDefaultSystemTray().addTrayIcon(this.trayIcon);
        backend.addListener(StatusChangeListener.class, (JETIListener)this);
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        backend.removeListener(StatusChangeListener.class, (JETIListener)plugin);
        if (plugin != null) {
            SystemTray.getDefaultSystemTray().removeTrayIcon(Plugin.plugin.trayIcon);
        }
        plugin = null;
    }

    public JPopupMenu makeMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu(I18N.gettext((String)"main.main.jetimenu.Account"));
        JMenuItem jMenuItem = new JMenuItem(I18N.gettext((String)"main.main.jetimenu.Login") + "...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.createLoginWindow((Backend)Plugin.this.backend);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(I18N.gettext((String)"main.main.jetimenu.Manage_Services") + "...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegisterServices(Plugin.this.backend).setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        jMenu = new JMenu(I18N.gettext((String)"systemtray.Status"));
        jMenuItem = new JMenuItem(I18N.gettext((String)"main.main.statusmenu.Change_message"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Plugin.this.backend.getMainWindow(), (Object)I18N.gettext((String)"main.main.statusmenu.Status_message"));
                if (string == null) {
                    return;
                }
                StatusButton.changeStatus((int)Plugin.this.status, (String)string);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(this.statusMenu(1));
        jMenu.add(this.statusMenu(2));
        jMenu.add(this.statusMenu(4));
        jMenu.add(this.statusMenu(3));
        jMenu.add(this.statusMenu(5));
        jMenuItem = new JMenuItem(I18N.gettext((String)"main.main.presencebutton.Invisible"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusButton.changeStatus((int)6, null);
            }
        });
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        jMenuItem = new JMenuItem(I18N.gettext((String)"main.main.jetimenu.Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Plugin.this.main.close();
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private JMenu statusMenu(final int n) {
        JMenu jMenu = new JMenu(Presence.toLongShow((int)n));
        List list = Preferences.getStatusMessages((int)n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            final String string = (String)iterator.next();
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StatusButton.changeStatus((int)n, (String)string);
                }
            });
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Container container = this.backend.getMainWindow();
        container.setVisible(true);
    }

    public void connectionChanged(boolean bl) {
        try {
            if (!bl) {
                this.trayIcon.setIcon((Icon)StatusIcons.getOfflineIcon());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void exit() {
        Plugin.unload(this.backend);
    }

    public void ownPresenceChanged(int n, String string) {
        try {
            this.status = n;
            this.trayIcon.setIcon((Icon)StatusIcons.getStatusIcon((int)n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

