/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.ColorBlind;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.plaf.CompierePLAFFrame;
import org.compiere.plaf.CompiereTheme;
import org.compiere.swing.CButton;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public final class CompierePLAF {
    public static final String VERSION = "R1.2.0";
    public static final String BACKGROUND = "CompiereBackground";
    public static final String BACKGROUND_FILL = "CompiereBackgroundFill";
    public static final String TABLEVEL = "CompiereTabLevel";
    public static final String DEFAULT_PLAF = "Compiere";
    public static final String DEFAULT_THEME = "";
    private static ValueNamePair[] s_looks;
    private static ValueNamePair s_defaultPLAF;
    private static ValueNamePair[] s_themes;
    private static ValueNamePair s_vp_compiereTheme;
    private static ValueNamePair s_vp_metalTheme;
    private static ValueNamePair s_vp_kunststoffTheme;
    static ResourceBundle s_res;
    static /* synthetic */ Class class$org$compiere$plaf$CompierePLAF;

    public static Color getFieldBackground_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("text"));
    }

    public static Color getFieldBackground_Error() {
        return ColorBlind.getDichromatColor(CompiereTheme.error);
    }

    public static Color getFieldBackground_Mandatory() {
        return ColorBlind.getDichromatColor(CompiereTheme.mandatory);
    }

    public static Color getFieldBackground_Inactive() {
        return ColorBlind.getDichromatColor(CompiereTheme.inactive);
    }

    public static Color getFormBackground() {
        return ColorBlind.getDichromatColor(UIManager.getColor("control"));
    }

    public static Color getInfoBackground() {
        return ColorBlind.getDichromatColor(CompiereTheme.info);
    }

    public static Color getTextColor_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("textText"));
    }

    public static Color getTextColor_OK() {
        return ColorBlind.getDichromatColor(CompiereTheme.txt_ok);
    }

    public static Color getTextColor_Issue() {
        return ColorBlind.getDichromatColor(CompiereTheme.txt_error);
    }

    public static Color getTextColor_Label() {
        return ColorBlind.getDichromatColor(UIManager.getColor("controlText"));
    }

    public static Color getPrimary1() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary1);
    }

    public static Color getPrimary2() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary2);
    }

    public static Color getPrimary3() {
        return ColorBlind.getDichromatColor(CompiereTheme.primary3);
    }

    public static Color getSecondary1() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary1);
    }

    public static Color getSecondary2() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary2);
    }

    public static Color getSecondary3() {
        return ColorBlind.getDichromatColor(CompiereTheme.secondary3);
    }

    public static Font getFont_Header() {
        return CompiereTheme.windowFont;
    }

    public static Font getFont_Field() {
        return CompiereTheme.userFont;
    }

    public static Font getFont_Label() {
        return CompiereTheme.controlFont;
    }

    public static Font getFont_Small() {
        return CompiereTheme.smallFont;
    }

    public static ValueNamePair[] getPLAFs() {
        return s_looks;
    }

    public static ValueNamePair[] getThemes() {
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            return s_themes;
        }
        return new ValueNamePair[0];
    }

    public static void setPLAF(Window win) {
        String look = Ini.getProperty("UILookFeel");
        String lookTheme = Ini.getProperty("UITheme");
        ValueNamePair plaf = null;
        int i = 0;
        while (i < s_looks.length) {
            if (s_looks[i].getName().equals(look)) {
                plaf = s_looks[i];
                break;
            }
            ++i;
        }
        ValueNamePair theme = null;
        int i2 = 0;
        while (i2 < s_themes.length) {
            if (s_themes[i2].getName().equals(lookTheme)) {
                theme = s_themes[i2];
                break;
            }
            ++i2;
        }
        CompierePLAF.setPLAF(plaf == null ? s_defaultPLAF : plaf, theme, win);
    }

    public static void setPLAF(ValueNamePair plaf, ValueNamePair theme, Window win) {
        if (plaf == null) {
            return;
        }
        System.out.println("PLAF = " + plaf + (theme == null ? DEFAULT_THEME : " - " + theme));
        try {
            UIManager.setLookAndFeel(plaf.getValue());
        }
        catch (Exception e) {
            System.err.println("CompierePLAF.setPLAF - " + e.getMessage());
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        Ini.setProperty("UILookFeel", plaf.getName());
        Ini.setProperty("UITheme", DEFAULT_THEME);
        if (theme == null && laf instanceof MetalLookAndFeel) {
            String className = laf.getClass().getName();
            if (className.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                theme = s_vp_metalTheme;
            } else if (className.equals("org.compiere.plaf.CompiereLookAndFeel")) {
                theme = s_vp_compiereTheme;
            } else if (className.equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
                theme = s_vp_kunststoffTheme;
            }
        }
        if (theme != null && laf instanceof MetalLookAndFeel && theme.getValue().length() > 0) {
            try {
                Class<?> c = Class.forName(theme.getValue());
                MetalTheme t = (MetalTheme)c.newInstance();
                if (laf instanceof CompiereLookAndFeel) {
                    CompiereLookAndFeel cfr_ignored_0 = (CompiereLookAndFeel)laf;
                    CompiereLookAndFeel.setCurrentTheme(t);
                } else {
                    MetalLookAndFeel cfr_ignored_1 = (MetalLookAndFeel)laf;
                    MetalLookAndFeel.setCurrentTheme(t);
                }
                CompiereTheme.setTheme(t);
                Ini.setProperty("UITheme", theme.getName());
            }
            catch (Exception e) {
                System.err.println("CompierePLAF.setPLAF Theme - " + e.getMessage());
            }
        }
        CompierePLAF.updateUI(win);
    }

    public static void updateUI(Window win) {
        if (win == null) {
            return;
        }
        Window c = win;
        do {
            SwingUtilities.updateComponentTreeUI(c);
            c.invalidate();
            c.pack();
            c.validate();
            c.repaint();
        } while ((c = c.getOwner()) != null);
    }

    public static void reset(Window win) {
        CompiereTheme.reset(Ini.getProperties());
        CompierePLAF.setPLAF(win);
    }

    public static void printPLAFDefaults() {
        System.out.println(UIManager.getLookAndFeel());
        Object[] keys = UIManager.getLookAndFeelDefaults().keySet().toArray();
        Arrays.sort(keys);
        char lastStart = ' ';
        int i = 0;
        while (i < keys.length) {
            StringBuffer sb = new StringBuffer();
            sb.append(keys[i]).append(" = ").append(UIManager.get(keys[i]));
            if (keys[i].toString().charAt(0) != lastStart) {
                System.out.println();
                lastStart = keys[i].toString().charAt(0);
            }
            System.out.println(sb);
            ++i;
        }
    }

    public static boolean isActive() {
        return UIManager.getLookAndFeel() instanceof CompiereLookAndFeel;
    }

    public static CButton getOKButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon((class$org$compiere$plaf$CompierePLAF == null ? (class$org$compiere$plaf$CompierePLAF = CompierePLAF.class$("org.compiere.plaf.CompierePLAF")) : class$org$compiere$plaf$CompierePLAF).getResource("icons/Ok24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("OK"));
        return b;
    }

    public static CButton getCancelButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon((class$org$compiere$plaf$CompierePLAF == null ? (class$org$compiere$plaf$CompierePLAF = CompierePLAF.class$("org.compiere.plaf.CompierePLAF")) : class$org$compiere$plaf$CompierePLAF).getResource("icons/Cancel24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("Cancel"));
        return b;
    }

    public static void showCenterScreen(Window window) {
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wSize = window.getSize();
        window.setLocation((sSize.width - wSize.width) / 2, (sSize.height - wSize.height) / 2);
        window.toFront();
        window.setVisible(true);
    }

    public static void main(String[] args) {
        String jVersion = System.getProperty("java.version");
        if (!jVersion.startsWith("1.4")) {
            JOptionPane.showMessageDialog(null, "Require Java Version 1.4 or up - Not " + jVersion, "CompierePLAF - Version Conflict", 0);
            System.exit(1);
        }
        Ini.loadProperties(true);
        CompiereTheme.load();
        CompierePLAF.setPLAF(null);
        if (args.length == 0) {
            CompierePLAFFrame frame = new CompierePLAFFrame();
            return;
        }
        String className = args[0];
        Class<?> startClass = null;
        try {
            startClass = Class.forName(className);
        }
        catch (Exception e) {
            System.err.println("Did not find: " + className);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Method[] methods = startClass.getMethods();
            int i = 0;
            if (i < methods.length) {
                if (Modifier.isStatic(methods[i].getModifiers()) && methods[i].getName().equals("main")) {
                    String[] startArgs = new String[args.length - 1];
                    int ii = 1;
                    while (ii < args.length) {
                        startArgs[ii - i] = args[ii];
                        ++ii;
                    }
                    methods[i].invoke(null, new Object[]{startArgs});
                }
                return;
            }
        }
        catch (Exception ee) {
            System.err.println("Problems invoking main");
            ee.printStackTrace();
        }
        try {
            startClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Cannot start: " + className);
            e.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VERSION = VERSION;
        BACKGROUND = BACKGROUND;
        BACKGROUND_FILL = BACKGROUND_FILL;
        TABLEVEL = TABLEVEL;
        DEFAULT_PLAF = DEFAULT_PLAF;
        DEFAULT_THEME = DEFAULT_THEME;
        s_looks = null;
        s_defaultPLAF = null;
        s_themes = null;
        s_vp_compiereTheme = null;
        s_vp_metalTheme = null;
        s_vp_kunststoffTheme = null;
        ArrayList<ValueNamePair> plafList = new ArrayList<ValueNamePair>();
        ValueNamePair vp = new ValueNamePair("org.compiere.plaf.CompiereLookAndFeel", DEFAULT_PLAF);
        plafList.add(vp);
        ArrayList<ValueNamePair> themeList = new ArrayList<ValueNamePair>();
        vp = new ValueNamePair("org.compiere.plaf.CompiereTheme", "Compiere Theme");
        themeList.add(vp);
        s_vp_compiereTheme = vp;
        s_vp_metalTheme = vp = new ValueNamePair("javax.swing.plaf.metal.DefaultMetalTheme", "Steel");
        themeList.add(vp);
        try {
            Class<?> c = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            vp = new ValueNamePair("com.incors.plaf.kunststoff.KunststoffLookAndFeel", "Kunststoff");
            plafList.add(vp);
            vp = new ValueNamePair("com.incors.plaf.kunststoff.KunststoffTheme", "Kuststoff");
            themeList.add(vp);
            s_vp_kunststoffTheme = vp;
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = 0;
        while (i < plafList.size()) {
            vp = (ValueNamePair)plafList.get(i);
            UIManager.installLookAndFeel(vp.getName(), vp.getValue());
            ++i;
        }
        plafList = new ArrayList();
        UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
        int i2 = 0;
        while (i2 < lfInfo.length) {
            vp = new ValueNamePair(lfInfo[i2].getClassName(), lfInfo[i2].getName());
            plafList.add(vp);
            if (lfInfo[i2].getName().equals(DEFAULT_PLAF)) {
                s_defaultPLAF = vp;
            }
            ++i2;
        }
        s_looks = new ValueNamePair[plafList.size()];
        plafList.toArray(s_looks);
        s_themes = new ValueNamePair[themeList.size()];
        themeList.toArray(s_themes);
        s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    }
}

