/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import org.compiere.plaf.CompiereColor;

public class CompiereUtils {
    public static final Color COL_1TOP = new Color(255, 255, 255, 128);
    public static final Color COL_1END = new Color(255, 255, 255, 0);
    public static final Color COL_2TOP = new Color(0, 0, 0, 0);
    public static final Color COL_2END = new Color(0, 0, 0, 64);
    protected static final Component s_component = new Component(){};
    protected static final MediaTracker s_tracker = new MediaTracker(s_component);
    private static int s_no = 0;

    public static void fillRectange(Graphics2D g2D, JComponent c, boolean round) {
        CompiereColor cc = null;
        boolean stdCC = c.getClientProperty("CompiereBackgroundFill") != null;
        try {
            cc = (CompiereColor)c.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            stdCC = true;
        }
        if (stdCC) {
            cc = CompiereColor.getDefaultBackground();
        }
        if (cc != null) {
            cc.paint(g2D, c);
        } else {
            Color paint = c.getBackground();
            g2D.setPaint(paint);
            RectangularShape rec = null;
            rec = round ? new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight(), 15.0f, 15.0f) : new Rectangle(0, 0, c.getWidth(), c.getHeight());
            g2D.fill(rec);
        }
    }

    public static void paint3Deffect(Graphics2D g2D, Rectangle r, boolean round, boolean out) {
        GradientPaint topPaint = null;
        topPaint = out ? new GradientPaint(r.x, r.y, COL_1TOP, r.x, r.y + r.height / 2, COL_1END) : new GradientPaint(r.x, r.y, COL_2END, r.x, r.y + r.height / 2, COL_2TOP);
        g2D.setPaint(topPaint);
        RectangularShape topRec = null;
        topRec = round ? new RoundRectangle2D.Float(r.x, r.y, r.width, r.height / 2, 15.0f, 15.0f) : new Rectangle(r.x, r.y, r.width, r.height / 2);
        g2D.fill(topRec);
        GradientPaint endPaint = null;
        endPaint = out ? new GradientPaint(r.x, r.y + r.height / 2, COL_2TOP, r.x, r.y + r.height, COL_2END) : new GradientPaint(r.x, r.y + r.height / 2, COL_1END, r.x, r.y + r.height, COL_1TOP);
        g2D.setPaint(endPaint);
        RectangularShape endRec = null;
        endRec = round ? new RoundRectangle2D.Float(r.x, r.y + r.height / 2, r.width, r.height / 2, 15.0f, 15.0f) : new Rectangle(r.x, r.y + r.height / 2, r.width, r.height / 2);
        g2D.fill(endRec);
    }

    public static void paint3Deffect(Graphics2D g2D, JComponent c, boolean round, boolean out) {
        GradientPaint topPaint = null;
        topPaint = out ? new GradientPaint(0.0f, 0.0f, COL_1TOP, 0.0f, c.getHeight() / 2, COL_1END) : new GradientPaint(0.0f, 0.0f, COL_2END, 0.0f, c.getHeight() / 2, COL_2TOP);
        g2D.setPaint(topPaint);
        RectangularShape topRec = null;
        topRec = round ? new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight() / 2, 15.0f, 15.0f) : new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
        g2D.fill(topRec);
        GradientPaint endPaint = null;
        endPaint = out ? new GradientPaint(0.0f, c.getHeight() / 2, COL_2TOP, 0.0f, c.getHeight(), COL_2END) : new GradientPaint(0.0f, c.getHeight() / 2, COL_1END, 0.0f, c.getHeight(), COL_1TOP);
        g2D.setPaint(endPaint);
        RectangularShape endRec = null;
        endRec = round ? new RoundRectangle2D.Float(0.0f, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2, 15.0f, 15.0f) : new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2);
        g2D.fill(endRec);
    }

    public static Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static void setNotBuffered(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(false);
        }
        if (c instanceof Container) {
            Component[] cc = ((Container)c).getComponents();
            int i = 0;
            while (i < cc.length) {
                CompiereUtils.setNotBuffered(cc[i]);
                ++i;
            }
        }
    }

    public static synchronized Image loadImage(String path) {
        Image image = null;
        try {
            File file = new File(path);
            URL url = file.toURL();
            image = CompiereUtils.loadImage(url);
        }
        catch (MalformedURLException e) {
            System.err.println("CompiereUtils.loadImage(path): " + e.getMessage());
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Image loadImage(URL url) {
        Image image = null;
        image = Toolkit.getDefaultToolkit().getImage(url);
        if (image != null) {
            s_tracker.addImage(image, 0);
            try {
                try {
                    s_tracker.waitForAll();
                }
                catch (InterruptedException e) {
                    System.err.println("CompiereUtils.loadImage(url): " + e.getMessage());
                    s_tracker.removeImage(image);
                    image = null;
                    Object var4_3 = null;
                    if (image != null) {
                        s_tracker.removeImage(image);
                    }
                    if (s_tracker.isErrorAny()) {
                        System.err.println("CompiereUtils.loadImage(url-tracker): " + s_tracker.getErrorsAny()[0]);
                        image = null;
                    }
                    if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                        System.err.println("CompiereUtils.loadImage(url-0)");
                        image = null;
                    }
                }
                Object var4_2 = null;
                if (image != null) {
                    s_tracker.removeImage(image);
                }
                if (s_tracker.isErrorAny()) {
                    System.err.println("CompiereUtils.loadImage(url-tracker): " + s_tracker.getErrorsAny()[0]);
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    System.err.println("CompiereUtils.loadImage(url-0)");
                    image = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (image != null) {
                    s_tracker.removeImage(image);
                }
                if (s_tracker.isErrorAny()) {
                    System.err.println("CompiereUtils.loadImage(url-tracker): " + s_tracker.getErrorsAny()[0]);
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    System.err.println("CompiereUtils.loadImage(url-0)");
                    image = null;
                }
                throw throwable;
            }
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(File file, int imageType) {
        BufferedImage image = null;
        try {
            URL url = file.toURL();
            image = CompiereUtils.loadBufferedImage(url, imageType);
        }
        catch (MalformedURLException e) {
            System.err.println("CompiereUtils.loadBufferedImage(file-t): " + e.getMessage());
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(String path, int imageType) {
        File file = new File(path);
        BufferedImage image = null;
        try {
            URL url = file.toURL();
            image = CompiereUtils.loadBufferedImage(url, imageType);
        }
        catch (MalformedURLException e) {
            System.err.println("CompiereUtils.loadBufferedImage(path-t): " + e.getMessage());
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(URL url, int imageType) {
        BufferedImage image = null;
        if (url == null || !url.toString().toLowerCase().endsWith(".jpg")) {
            Image tmpImage = CompiereUtils.loadImage(url);
            if (tmpImage != null) {
                image = new BufferedImage(tmpImage.getWidth(null), tmpImage.getHeight(null), imageType);
                Graphics2D g = image.createGraphics();
                g.drawImage(tmpImage, 0, 0, null);
                g.dispose();
            }
        } else {
            BufferedImage tmpImage = CompiereUtils.loadBufferedJPEGImage(url);
            if (tmpImage != null) {
                if (tmpImage.getType() != imageType) {
                    image = new BufferedImage(tmpImage.getWidth(null), tmpImage.getHeight(null), imageType);
                    Graphics2D g = image.createGraphics();
                    g.drawImage((Image)tmpImage, 0, 0, null);
                    g.dispose();
                } else {
                    image = tmpImage;
                }
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized BufferedImage loadBufferedJPEGImage(URL url) {
        BufferedImage image;
        block13: {
            block12: {
                image = null;
                if (url == null) break block13;
                InputStream in = null;
                in = url.openStream();
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                image = decoder.decodeAsBufferedImage();
                Object var5_5 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block12;
                }
                catch (IOException ioe) {
                    System.err.println("CompiereUtils.loadJPEGImage: " + ioe.getMessage());
                }
                break block12;
                {
                    catch (Exception e) {
                        System.err.println("CompiereUtils.loadJPEGImage: " + e.getMessage());
                        image = null;
                        Object var5_6 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block12;
                        }
                        catch (IOException ioe) {
                            System.err.println("CompiereUtils.loadJPEGImage: " + ioe.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.err.println("CompiereUtils.loadJPEGImage: " + ioe.getMessage());
                    }
                    throw throwable;
                }
            }
            if (image != null && (image.getWidth() <= 0 || image.getHeight() <= 0)) {
                System.err.println("CompiereUtils.loadJPEGImage-0");
                image = null;
            }
        }
        return image;
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static void printParents(JComponent c) {
        if (c.getName() == null) {
            c.setName("C" + String.valueOf(s_no++));
        }
        System.out.print(c.getName());
        System.out.print(" - " + c.getClass().getName());
        System.out.println(" ** " + c.isOpaque() + " bg=" + (c.getClientProperty("CompiereBackground") != null));
        Container container = c.getParent();
        while (container != null) {
            System.out.print(" - " + container.getName() + " " + container.getClass().getName() + " ** " + container.isOpaque());
            if (container instanceof JComponent) {
                System.out.print(" bg=" + (((JComponent)container).getClientProperty("CompiereBackground") != null));
            }
            System.out.println();
            container = container.getParent();
        }
    }
}

