/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.plaf.ComboBoxUI;
import org.compiere.plaf.CompiereComboBoxUI;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CEditor;
import org.compiere.util.Trace;

public class CComboBox
extends JComboBox
implements CEditor {
    private Icon m_icon = null;
    private boolean m_mandatory = false;

    public CComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    public CComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public CComboBox(Vector items) {
        super(items);
        this.init();
    }

    public CComboBox() {
        this.init();
    }

    private void init() {
        this.setFont(CompierePLAF.getFont_Field());
        this.setForeground(CompierePLAF.getTextColor_Normal());
        this.setBackground(false);
    }

    public void setIcon(Icon defaultIcon) {
        if (this.getUI() instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(defaultIcon);
        }
        this.m_icon = defaultIcon;
    }

    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
        if (this.m_icon != null && ui instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(this.m_icon);
        }
    }

    public boolean displayPopup() {
        return true;
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.setBackground(false);
    }

    public boolean isReadWrite() {
        return super.isEnabled();
    }

    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setValue(Object value) {
        super.setSelectedItem(value);
    }

    public Object getValue() {
        return super.getSelectedItem();
    }

    public String getDisplay() {
        Object o = super.getSelectedItem();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public void addMouseListener(MouseListener ml) {
        JButton b;
        super.addMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && !Trace.getCallerClass(1).startsWith("javax") && (b = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b.addMouseListener(ml);
        }
    }

    public void removeMouseListener(MouseListener ml) {
        JButton b;
        super.removeMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && (b = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b.removeMouseListener(ml);
        }
    }
}

