/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;

public class Trace {
    public static String[] getCallerClasses(Throwable caller, int maxNestLevel) {
        int nestLevel = maxNestLevel;
        if (nestLevel < 1) {
            nestLevel = 99;
        }
        ArrayList<String> list = new ArrayList<String>();
        Throwable t = caller;
        if (t == null) {
            t = new Throwable();
        }
        StackTraceElement[] elements = t.getStackTrace();
        int i = 0;
        while (i < elements.length && list.size() <= maxNestLevel) {
            String className = elements[i].getClassName();
            if (!className.startsWith("org.compiere.util.Trace") && !className.startsWith("java.lang.Throwable")) {
                list.add(className);
            }
            ++i;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static String getCallerClass(int nestLevel) {
        String[] array = Trace.getCallerClasses(null, nestLevel);
        if (array.length < nestLevel) {
            return "";
        }
        return array[nestLevel];
    }

    public static void printStack() {
        Throwable t = new Throwable();
        t.printStackTrace();
    }
}

