/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class ChangeRequest
extends MessageAttribute {
    boolean changeIP = false;
    boolean changePort = false;

    public ChangeRequest() {
        super(MessageAttributeInterface.MessageAttributeType.ChangeRequest);
    }

    public boolean isChangeIP() {
        return this.changeIP;
    }

    public boolean isChangePort() {
        return this.changePort;
    }

    public void setChangeIP() {
        this.changeIP = true;
    }

    public void setChangePort() {
        this.changePort = true;
    }

    public byte[] getBytes() throws UtilityException {
        byte[] byArray = new byte[8];
        System.arraycopy(Utility.IntegerToTwoBytes(ChangeRequest.typeToInteger(this.type)), 0, byArray, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(4), 0, byArray, 2, 2);
        if (this.changeIP) {
            byArray[7] = Utility.IntegerToOneByte(4);
        }
        if (this.changePort) {
            byArray[7] = Utility.IntegerToOneByte(2);
        }
        if (this.changeIP && this.changePort) {
            byArray[7] = Utility.IntegerToOneByte(6);
        }
        return byArray;
    }

    public static ChangeRequest parse(byte[] byArray) throws MessageAttributeParsingException {
        try {
            if (byArray.length < 4) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            ChangeRequest changeRequest = new ChangeRequest();
            int n = Utility.OneByteToInteger(byArray[3]);
            switch (n) {
                case 2: {
                    changeRequest.setChangePort();
                    break;
                }
                case 4: {
                    changeRequest.setChangeIP();
                    break;
                }
                case 6: {
                    changeRequest.setChangeIP();
                    changeRequest.setChangePort();
                    break;
                }
                default: {
                    throw new MessageAttributeParsingException("Status parsing error");
                }
            }
            return changeRequest;
        }
        catch (UtilityException utilityException) {
            throw new MessageAttributeParsingException("Parsing error");
        }
    }
}

