/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.Dummy;
import de.javawi.jstun.attribute.ErrorCode;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.attribute.MessageIntegrity;
import de.javawi.jstun.attribute.Password;
import de.javawi.jstun.attribute.ReflectedFrom;
import de.javawi.jstun.attribute.ResponseAddress;
import de.javawi.jstun.attribute.SourceAddress;
import de.javawi.jstun.attribute.UnknownAttribute;
import de.javawi.jstun.attribute.Username;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;
import java.util.logging.Logger;

public abstract class MessageAttribute
implements MessageAttributeInterface {
    private static Logger logger = Logger.getLogger("de.javawi.stun.util.MessageAttribute");
    MessageAttributeInterface.MessageAttributeType type;
    int length;

    public MessageAttribute() {
    }

    public MessageAttribute(MessageAttributeInterface.MessageAttributeType messageAttributeType) {
        this.setType(messageAttributeType);
    }

    public void setType(MessageAttributeInterface.MessageAttributeType messageAttributeType) {
        this.type = messageAttributeType;
    }

    public MessageAttributeInterface.MessageAttributeType getType() {
        return this.type;
    }

    public static int typeToInteger(MessageAttributeInterface.MessageAttributeType messageAttributeType) {
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.MappedAddress) {
            return 1;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.ResponseAddress) {
            return 2;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.ChangeRequest) {
            return 3;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.SourceAddress) {
            return 4;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.ChangedAddress) {
            return 5;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.Username) {
            return 6;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.Password) {
            return 7;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.MessageIntegrity) {
            return 8;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.ErrorCode) {
            return 9;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.UnknownAttribute) {
            return 10;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.ReflectedFrom) {
            return 11;
        }
        if (messageAttributeType == MessageAttributeInterface.MessageAttributeType.Dummy) {
            return 0;
        }
        return -1;
    }

    public static MessageAttributeInterface.MessageAttributeType intToType(long l) {
        if (l == 1L) {
            return MessageAttributeInterface.MessageAttributeType.MappedAddress;
        }
        if (l == 2L) {
            return MessageAttributeInterface.MessageAttributeType.ResponseAddress;
        }
        if (l == 3L) {
            return MessageAttributeInterface.MessageAttributeType.ChangeRequest;
        }
        if (l == 4L) {
            return MessageAttributeInterface.MessageAttributeType.SourceAddress;
        }
        if (l == 5L) {
            return MessageAttributeInterface.MessageAttributeType.ChangedAddress;
        }
        if (l == 6L) {
            return MessageAttributeInterface.MessageAttributeType.Username;
        }
        if (l == 7L) {
            return MessageAttributeInterface.MessageAttributeType.Password;
        }
        if (l == 8L) {
            return MessageAttributeInterface.MessageAttributeType.MessageIntegrity;
        }
        if (l == 9L) {
            return MessageAttributeInterface.MessageAttributeType.ErrorCode;
        }
        if (l == 10L) {
            return MessageAttributeInterface.MessageAttributeType.UnknownAttribute;
        }
        if (l == 11L) {
            return MessageAttributeInterface.MessageAttributeType.ReflectedFrom;
        }
        if (l == 0L) {
            return MessageAttributeInterface.MessageAttributeType.Dummy;
        }
        return MessageAttributeInterface.MessageAttributeType.Dummy;
    }

    public abstract byte[] getBytes() throws UtilityException;

    public int getLength() throws UtilityException {
        int n = this.getBytes().length;
        return n;
    }

    public static MessageAttribute parseCommonHeader(byte[] byArray) throws MessageAttributeParsingException {
        try {
            MessageAttribute messageAttribute;
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 0, byArray2, 0, 2);
            int n = Utility.TwoBytesToInteger(byArray2);
            byte[] byArray3 = new byte[2];
            System.arraycopy(byArray, 2, byArray3, 0, 2);
            int n2 = Utility.TwoBytesToInteger(byArray3);
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray, 4, byArray4, 0, n2);
            switch (n) {
                case 1: {
                    messageAttribute = MappedAddress.parse(byArray4);
                    break;
                }
                case 2: {
                    messageAttribute = ResponseAddress.parse(byArray4);
                    break;
                }
                case 3: {
                    messageAttribute = ChangeRequest.parse(byArray4);
                    break;
                }
                case 4: {
                    messageAttribute = SourceAddress.parse(byArray4);
                    break;
                }
                case 5: {
                    messageAttribute = ChangedAddress.parse(byArray4);
                    break;
                }
                case 6: {
                    messageAttribute = Username.parse(byArray4);
                    break;
                }
                case 7: {
                    messageAttribute = Password.parse(byArray4);
                    break;
                }
                case 8: {
                    messageAttribute = MessageIntegrity.parse(byArray4);
                    break;
                }
                case 9: {
                    messageAttribute = ErrorCode.parse(byArray4);
                    break;
                }
                case 10: {
                    messageAttribute = UnknownAttribute.parse(byArray4);
                    break;
                }
                case 11: {
                    messageAttribute = ReflectedFrom.parse(byArray4);
                    break;
                }
                default: {
                    logger.config("MessageAttribute with type " + n + " unkown" + ".");
                    messageAttribute = Dummy.parse(byArray4);
                }
            }
            return messageAttribute;
        }
        catch (UtilityException utilityException) {
            throw new MessageAttributeParsingException("Parsing Error");
        }
    }
}

