/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ErrorCode;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.attribute.ResponseAddress;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class BindingLifetimeTest {
    private static Logger logger = Logger.getLogger("de.javawi.stun.test.BindingLifetimeTest");
    String stunServer;
    int port;
    int timeout = 300;
    MappedAddress ma;
    Timer timer;
    DatagramSocket initialSocket;
    int upperBinarySearchLifetime = 345000;
    int lowerBinarySearchLifetime = 0;
    int binarySearchLifetime = (this.upperBinarySearchLifetime + this.lowerBinarySearchLifetime) / 2;
    int lifetime = -1;
    boolean completed = false;

    public BindingLifetimeTest(String string, int n) {
        this.stunServer = string;
        this.port = n;
        this.timer = new Timer(true);
    }

    public void test() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        this.initialSocket = new DatagramSocket();
        this.initialSocket.connect(InetAddress.getByName(this.stunServer), this.port);
        this.initialSocket.setSoTimeout(this.timeout);
        if (this.BindingCommunicationInitialSocket()) {
            return;
        }
        BindingLifetimeTask bindingLifetimeTask = new BindingLifetimeTask();
        this.timer.schedule((TimerTask)bindingLifetimeTask, this.binarySearchLifetime);
        logger.finer("Timer scheduled initially: " + this.binarySearchLifetime + ".");
    }

    private boolean BindingCommunicationInitialSocket() throws UtilityException, IOException, MessageHeaderParsingException, MessageAttributeParsingException {
        Object object;
        MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
        messageHeader.generateTransactionID();
        ChangeRequest changeRequest = new ChangeRequest();
        messageHeader.addMessageAttribute(changeRequest);
        byte[] byArray = messageHeader.getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.stunServer), this.port);
        this.initialSocket.send(datagramPacket);
        logger.finer("Binding Request sent.");
        MessageHeader messageHeader2 = new MessageHeader();
        while (!messageHeader2.equalTransactionID(messageHeader)) {
            object = new DatagramPacket(new byte[200], 200);
            this.initialSocket.receive((DatagramPacket)object);
            messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
        }
        this.ma = (MappedAddress)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
        object = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
        if (object != null) {
            logger.config("Message header contains errorcode message attribute.");
            return true;
        }
        if (this.ma == null) {
            logger.config("Response does not contain a mapped address message attribute.");
            return true;
        }
        return false;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setUpperBinarySearchLifetime(int n) {
        this.upperBinarySearchLifetime = n;
        this.binarySearchLifetime = (n + this.lowerBinarySearchLifetime) / 2;
    }

    class BindingLifetimeTask
    extends TimerTask {
        public void run() {
            try {
                this.lifetimeQuery();
            }
            catch (Exception exception) {
                logger.config("Unhandled Exception. BindLifetimeTasks stopped.");
                exception.printStackTrace();
            }
        }

        public void lifetimeQuery() throws UtilityException, MessageAttributeException, MessageHeaderParsingException, MessageAttributeParsingException, IOException {
            try {
                Object object;
                DatagramSocket datagramSocket = new DatagramSocket();
                datagramSocket.connect(InetAddress.getByName(BindingLifetimeTest.this.stunServer), BindingLifetimeTest.this.port);
                datagramSocket.setSoTimeout(BindingLifetimeTest.this.timeout);
                MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                messageHeader.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                ResponseAddress responseAddress = new ResponseAddress();
                responseAddress.setAddress(BindingLifetimeTest.this.ma.getAddress());
                responseAddress.setPort(BindingLifetimeTest.this.ma.getPort());
                messageHeader.addMessageAttribute(changeRequest);
                messageHeader.addMessageAttribute(responseAddress);
                byte[] byArray = messageHeader.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(BindingLifetimeTest.this.stunServer), BindingLifetimeTest.this.port);
                datagramSocket.send(datagramPacket);
                logger.finer("Binding Request sent.");
                MessageHeader messageHeader2 = new MessageHeader();
                while (!messageHeader2.equalTransactionID(messageHeader)) {
                    object = new DatagramPacket(new byte[200], 200);
                    BindingLifetimeTest.this.initialSocket.receive((DatagramPacket)object);
                    messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
                }
                object = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (object != null) {
                    logger.config("Message header contains errorcode message attribute.");
                    return;
                }
                logger.finer("Binding Response received.");
                if (BindingLifetimeTest.this.upperBinarySearchLifetime == BindingLifetimeTest.this.lowerBinarySearchLifetime + 1) {
                    logger.config("BindingLifetimeTest completed. UDP binding lifetime: " + BindingLifetimeTest.this.binarySearchLifetime + ".");
                    BindingLifetimeTest.this.completed = true;
                    return;
                }
                BindingLifetimeTest.this.lifetime = BindingLifetimeTest.this.binarySearchLifetime;
                logger.finer("Lifetime update: " + BindingLifetimeTest.this.lifetime + ".");
                BindingLifetimeTest.this.lowerBinarySearchLifetime = BindingLifetimeTest.this.binarySearchLifetime;
                BindingLifetimeTest.this.binarySearchLifetime = (BindingLifetimeTest.this.upperBinarySearchLifetime + BindingLifetimeTest.this.lowerBinarySearchLifetime) / 2;
                if (BindingLifetimeTest.this.binarySearchLifetime > 0) {
                    BindingLifetimeTask bindingLifetimeTask = new BindingLifetimeTask();
                    BindingLifetimeTest.this.timer.schedule((TimerTask)bindingLifetimeTask, BindingLifetimeTest.this.binarySearchLifetime);
                    logger.finer("Timer scheduled: " + BindingLifetimeTest.this.binarySearchLifetime + ".");
                } else {
                    BindingLifetimeTest.this.completed = true;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                logger.finest("Read operation at query socket timeout.");
                if (BindingLifetimeTest.this.upperBinarySearchLifetime == BindingLifetimeTest.this.lowerBinarySearchLifetime + 1) {
                    logger.config("BindingLifetimeTest completed. UDP binding lifetime: " + BindingLifetimeTest.this.binarySearchLifetime + ".");
                    BindingLifetimeTest.this.completed = true;
                    return;
                }
                BindingLifetimeTest.this.upperBinarySearchLifetime = BindingLifetimeTest.this.binarySearchLifetime;
                BindingLifetimeTest.this.binarySearchLifetime = (BindingLifetimeTest.this.upperBinarySearchLifetime + BindingLifetimeTest.this.lowerBinarySearchLifetime) / 2;
                if (BindingLifetimeTest.this.binarySearchLifetime > 0) {
                    if (BindingLifetimeTest.this.BindingCommunicationInitialSocket()) {
                        return;
                    }
                    BindingLifetimeTask bindingLifetimeTask = new BindingLifetimeTask();
                    BindingLifetimeTest.this.timer.schedule((TimerTask)bindingLifetimeTask, BindingLifetimeTest.this.binarySearchLifetime);
                    logger.finer("Timer scheduled: " + BindingLifetimeTest.this.binarySearchLifetime + ".");
                }
                BindingLifetimeTest.this.completed = true;
            }
        }
    }
}

