/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.util;

import de.javawi.jstun.util.UtilityException;

public class Utility {
    public static final byte IntegerToOneByte(int n) throws UtilityException {
        if ((double)n > Math.pow(2.0, 15.0) || n < 0) {
            throw new UtilityException("Integer value " + n + " is larger than 2^15");
        }
        return (byte)(n & 0xFF);
    }

    public static final byte[] IntegerToTwoBytes(int n) throws UtilityException {
        byte[] byArray = new byte[2];
        if ((double)n > Math.pow(2.0, 31.0) || n < 0) {
            throw new UtilityException("Integer value " + n + " is larger than 2^31");
        }
        byArray[0] = (byte)(n >>> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    public static final byte[] IntegerToFourBytes(int n) throws UtilityException {
        byte[] byArray = new byte[4];
        if ((double)n > Math.pow(2.0, 63.0) || n < 0) {
            throw new UtilityException("Integer value " + n + " is larger than 2^63");
        }
        byArray[0] = (byte)(n >>> 24 & 0xFF);
        byArray[1] = (byte)(n >>> 16 & 0xFF);
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        return byArray;
    }

    public static final int OneByteToInteger(byte by) throws UtilityException {
        return by & 0xFF;
    }

    public static final int TwoBytesToInteger(byte[] byArray) throws UtilityException {
        if (byArray.length < 2) {
            throw new UtilityException("Byte array too short!");
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        return (n << 8) + n2;
    }

    public static final long FourBytesToLong(byte[] byArray) throws UtilityException {
        if (byArray.length < 4) {
            throw new UtilityException("Byte array too short!");
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        return ((long)n << 24) + (long)(n2 << 16) + (long)(n3 << 8) + (long)n4;
    }
}

