/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle;

import java.util.List;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleSessionRequest;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleMediaListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleTransportListener;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.media.MediaNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.nat.JingleTransportManager;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolver;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleError;

public class IncomingJingleSession
extends JingleSession {
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;
    private JingleSessionRequest initialSessionRequest;

    protected IncomingJingleSession(Backend backend, JID jID, List list, JingleTransportManager jingleTransportManager, JingleSessionRequest jingleSessionRequest) throws XMPPException {
        super(backend, jID, backend.getMyJID());
        this.setSid(jingleSessionRequest.getSessionID());
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
        TransportResolver transportResolver = null;
        transportResolver = jingleTransportManager.getResolver(this);
        this.setMediaNeg(new MediaNegotiator(this, list));
        if (transportResolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
            this.setTransportNeg(new TransportNegotiator.RawUdp(this, transportResolver));
        }
        if (transportResolver.getType().equals((Object)TransportResolver.Type.ice)) {
            this.setTransportNeg(new TransportNegotiator.Ice(this, transportResolver));
        }
    }

    protected IncomingJingleSession(Backend backend, JID jID, List list, JingleTransportManager jingleTransportManager, JingleMediaManager jingleMediaManager, JingleSessionRequest jingleSessionRequest) throws XMPPException {
        this(backend, jID, list, jingleTransportManager, jingleSessionRequest);
        this.jingleMediaManager = jingleMediaManager;
    }

    public void start(JingleSessionRequest jingleSessionRequest) throws XMPPException {
        this.setState(this.accepting);
        Jingle jingle = jingleSessionRequest.getJingle();
        if (jingle == null) {
            throw new XMPPException("Session request with null Jingle packet.");
        }
        this.setSid(jingle.getSid());
        this.respond(jingle);
    }

    public void start() throws XMPPException {
        this.start(this.getInitialSessionRequest());
    }

    public JingleSessionRequest getInitialSessionRequest() {
        return this.initialSessionRequest;
    }

    public void setInitialSessionRequest(JingleSessionRequest jingleSessionRequest) {
        this.initialSessionRequest = jingleSessionRequest;
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
        }

        public void eventEnter() {
            PayloadType.Audio audio = IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
            TransportCandidate transportCandidate = IncomingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
            TransportCandidate transportCandidate2 = IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
            IncomingJingleSession.this.triggerSessionEstablished(audio, transportCandidate, transportCandidate2);
            super.eventEnter();
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }

        public void eventError(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosedOnError(new XMPPException(jingle.getError().getFirstXMPPError().getError()));
            super.eventError(jingle);
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        JingleMediaListener jingleMediaListener;
        JingleTransportListener jingleTransportListener;

        public Pending(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
            this.jingleMediaListener = new JingleMediaListener(){

                public void mediaClosed(PayloadType payloadType) {
                }

                public void mediaEstablished(PayloadType payloadType) {
                    Pending.this.checkFullyEstablished();
                }
            };
            this.jingleTransportListener = new JingleTransportListener(){

                public void transportEstablished(TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
                    Pending.this.checkFullyEstablished();
                }

                public void transportClosed(TransportCandidate transportCandidate) {
                }

                public void transportClosedOnError(XMPPException xMPPException) {
                }
            };
        }

        public void eventEnter() {
            IncomingJingleSession.this.addMediaListener(this.jingleMediaListener);
            IncomingJingleSession.this.addTransportListener(this.jingleTransportListener);
            super.eventEnter();
        }

        public void eventExit() {
            IncomingJingleSession.this.removeMediaListener(this.jingleMediaListener);
            IncomingJingleSession.this.removeTransportListener(this.jingleTransportListener);
            super.eventExit();
        }

        private void checkFullyEstablished() {
            if (IncomingJingleSession.this.isFullyEstablished()) {
                PayloadType.Audio audio = IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
                TransportCandidate transportCandidate = IncomingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
                TransportCandidate transportCandidate2 = IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
                if (audio != null && transportCandidate != null && transportCandidate2 != null) {
                    Jingle jingle = new Jingle(Jingle.Action.SESSIONACCEPT);
                    jingle.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType(audio)));
                    jingle.addTransport(IncomingJingleSession.this.getTransportNeg().getJingleTransport(transportCandidate));
                    IncomingJingleSession.this.addExpectedId(jingle.getPacketID());
                    IncomingJingleSession.this.sendFormattedJingle(jingle);
                }
            }
        }

        public Jingle eventAccept(Jingle jingle) throws XMPPException {
            PayloadType.Audio audio = null;
            TransportCandidate transportCandidate = null;
            if (IncomingJingleSession.this.isFullyEstablished()) {
                audio = IncomingJingleSession.this.getAcceptedAudioPayloadType(jingle);
                transportCandidate = IncomingJingleSession.this.getAcceptedLocalCandidate(jingle);
                if (audio != null && transportCandidate != null) {
                    if (((PayloadType)audio).equals(IncomingJingleSession.this.getMediaNeg().getBestCommonAudioPt()) && transportCandidate.equals(IncomingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate())) {
                        IncomingJingleSession.this.setState(IncomingJingleSession.this.active);
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.MALFORMED_STANZA);
                }
            }
            return super.eventAccept(jingle);
        }

        public Jingle eventAck(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.setState(IncomingJingleSession.this.active);
            return super.eventAck(jingle);
        }

        public void eventError(Jingle jingle) throws XMPPException {
            if (jingle == null) {
                return;
            }
            IncomingJingleSession.this.triggerSessionClosedOnError(new JingleNegotiator.JingleException(jingle.getError()));
            super.eventError(jingle);
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }
    }

    public class Accepting
    extends JingleNegotiator.State {
        public Accepting(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
        }

        public Jingle eventInitiate(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.setState(IncomingJingleSession.this.pending);
            return super.eventInitiate(jingle);
        }

        public void eventError(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosedOnError(new JingleNegotiator.JingleException(jingle.getError().getFirstXMPPError().getError()));
            super.eventError(jingle);
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            IncomingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }
    }
}

