/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.IncomingJingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleSessionRequest;
import nu.fw.jeti.plugins.jingle.jingle.OutgoingJingleSession;
import nu.fw.jeti.plugins.jingle.jingle.listeners.CreatedJingleSessionListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionRequestListener;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.nat.BasicResolver;
import nu.fw.jeti.plugins.jingle.jingle.nat.JingleTransportManager;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolver;
import nu.fw.jeti.plugins.jingle.packet.Jingle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleManager
implements JingleSessionListener {
    final List<JingleSession> jingleSessions = new ArrayList<JingleSession>();
    private List<JingleSessionRequestListener> jingleSessionRequestListeners;
    private List<CreatedJingleSessionListener> creationListeners = new ArrayList<CreatedJingleSessionListener>();
    private Backend connection;
    private JingleMediaManager jingleMediaManager;
    private final JingleTransportManager jingleTransportManager;
    private static final /* synthetic */ Class class$nu$fw$jeti$events$StatusChangeListener;

    public JingleManager(final Backend backend, JingleTransportManager jingleTransportManager, JingleMediaManager jingleMediaManager) {
        this.connection = backend;
        this.jingleTransportManager = jingleTransportManager;
        this.jingleMediaManager = jingleMediaManager;
        Class<?> clazz = class$nu$fw$jeti$events$StatusChangeListener;
        if (clazz == null) {
            clazz = class$nu$fw$jeti$events$StatusChangeListener = new StatusChangeListener[0].getClass().getComponentType();
        }
        backend.addListener(clazz, (JETIListener)new StatusChangeListener(){

            public void exit() {
            }

            public void ownPresenceChanged(int n, String string) {
            }

            public void connectionChanged(boolean bl) {
                if (!bl) {
                    JID jID = backend.getMyJID();
                    JingleSession jingleSession = null;
                    Iterator<JingleSession> iterator = JingleManager.this.jingleSessions.iterator();
                    while (iterator.hasNext()) {
                        JingleSession jingleSession2 = iterator.next();
                        if (!jingleSession2.getInitiator().equals(jID) && !jingleSession2.getResponder().equals(jID)) continue;
                        jingleSession = jingleSession2;
                    }
                    if (jingleSession != null) {
                        try {
                            jingleSession.terminate();
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public JingleManager(Backend backend, JingleTransportManager jingleTransportManager) {
        this(backend, jingleTransportManager, null);
    }

    public JingleManager(Backend backend) {
        this(backend, new JingleTransportManager(){

            protected TransportResolver createResolver(JingleSession jingleSession) {
                return new BasicResolver();
            }
        });
        JingleManager.setServiceEnabled(backend, true);
    }

    public JingleManager(Backend backend, final TransportResolver transportResolver) {
        this(backend, new JingleTransportManager(){

            protected TransportResolver createResolver(JingleSession jingleSession) {
                return transportResolver;
            }
        });
    }

    public static synchronized void setServiceEnabled(Backend backend, boolean bl) {
        if (JingleManager.isServiceEnabled(backend) == bl) {
            return;
        }
        if (bl) {
            backend.addCapability("jingle", "http://jabber.org/protocol/jingle");
        } else {
            backend.removeCapability("jingle", "http://jabber.org/protocol/jingle");
        }
    }

    public static boolean isServiceEnabled(Backend backend) {
        return true;
    }

    public static boolean isServiceEnabled(Backend backend, JID jID) {
        return backend.hasCapability(jID, "http://jabber.org/protocol/jingle");
    }

    public JingleTransportManager getJingleTransportManager() {
        return this.jingleTransportManager;
    }

    public JingleMediaManager getMediaManager() {
        return this.jingleMediaManager;
    }

    public void setMediaManager(JingleMediaManager jingleMediaManager) {
        this.jingleMediaManager = jingleMediaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (jingleSessionRequestListener != null) {
            if (this.jingleSessionRequestListeners == null) {
                this.jingleSessionRequestListeners = new ArrayList<JingleSessionRequestListener>();
            }
            List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
            synchronized (list) {
                this.jingleSessionRequestListeners.add(jingleSessionRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (this.jingleSessionRequestListeners == null) {
            return;
        }
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            this.jingleSessionRequestListeners.remove(jingleSessionRequestListener);
        }
    }

    public void addCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.add(createdJingleSessionListener);
    }

    public void removeCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.remove(createdJingleSessionListener);
    }

    public void triggerSessionCreated(JingleSession jingleSession) {
        System.err.println(new StringBuffer().append(jingleSession.getSid()).append("created").toString());
        this.jingleSessions.add(jingleSession);
        jingleSession.addListener(this);
        for (CreatedJingleSessionListener createdJingleSessionListener : this.creationListeners) {
            try {
                createdJingleSessionListener.sessionCreated(jingleSession);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void sessionEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, JingleSession jingleSession) {
    }

    @Override
    public void sessionDeclined(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
        jingleSession.close();
        System.err.println(new StringBuffer().append("Declined:").append(string).toString());
    }

    @Override
    public void sessionRedirected(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosed(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosedOnError(XMPPException xMPPException, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String string) {
    }

    public void disconnectAllSessions() {
        List<JingleSession> list = this.jingleSessions.subList(0, this.jingleSessions.size());
        for (JingleSession jingleSession : list) {
            try {
                jingleSession.terminate();
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSessionRequested(Jingle jingle) {
        JingleSessionRequestListener[] jingleSessionRequestListenerArray = null;
        Object object = this.jingleSessionRequestListeners;
        synchronized (object) {
            jingleSessionRequestListenerArray = new JingleSessionRequestListener[this.jingleSessionRequestListeners.size()];
            this.jingleSessionRequestListeners.toArray(jingleSessionRequestListenerArray);
        }
        object = new JingleSessionRequest(this, jingle);
        for (int i = 0; i < jingleSessionRequestListenerArray.length; ++i) {
            jingleSessionRequestListenerArray[i].sessionRequested((JingleSessionRequest)object);
        }
    }

    public OutgoingJingleSession createOutgoingJingleSession(JID jID, List<PayloadType> list) throws XMPPException {
        System.err.println("outgoing created");
        OutgoingJingleSession outgoingJingleSession = this.jingleMediaManager != null ? new OutgoingJingleSession(this.connection, jID, list, this.jingleTransportManager, this.jingleMediaManager) : new OutgoingJingleSession(this.connection, jID, list, this.jingleTransportManager);
        this.triggerSessionCreated(outgoingJingleSession);
        return outgoingJingleSession;
    }

    public OutgoingJingleSession createOutgoingJingleSession(JID jID) throws XMPPException {
        if (this.getMediaManager() == null) {
            return null;
        }
        return this.createOutgoingJingleSession(jID, this.getMediaManager().getPayloads());
    }

    IncomingJingleSession createIncomingJingleSession(JingleSessionRequest jingleSessionRequest, List<PayloadType> list) throws XMPPException {
        System.out.println("triggered incoming");
        if (jingleSessionRequest == null) {
            throw new NullPointerException("Received request cannot be null");
        }
        IncomingJingleSession incomingJingleSession = this.jingleMediaManager != null ? new IncomingJingleSession(this.connection, jingleSessionRequest.getFrom(), list, this.jingleTransportManager, this.jingleMediaManager, jingleSessionRequest) : new IncomingJingleSession(this.connection, jingleSessionRequest.getFrom(), list, this.jingleTransportManager, jingleSessionRequest);
        this.triggerSessionCreated(incomingJingleSession);
        return incomingJingleSession;
    }

    IncomingJingleSession createIncomingJingleSession(JingleSessionRequest jingleSessionRequest) throws XMPPException {
        if (jingleSessionRequest == null) {
            throw new NullPointerException("JingleMediaManager is not defined");
        }
        if (this.jingleMediaManager != null) {
            return this.createIncomingJingleSession(jingleSessionRequest, this.jingleMediaManager.getPayloads());
        }
        return this.createIncomingJingleSession(jingleSessionRequest, null);
    }

    public JingleSession getSession(JID jID) {
        for (JingleSession jingleSession : this.jingleSessions) {
            if (!(jingleSession instanceof OutgoingJingleSession ? jingleSession.getResponder().equals(jID) : jingleSession instanceof IncomingJingleSession && jingleSession.getInitiator().equals(jID))) continue;
            return jingleSession;
        }
        return null;
    }

    public JingleSession getSession(String string) {
        for (JingleSession jingleSession : this.jingleSessions) {
            if (!(jingleSession instanceof OutgoingJingleSession ? jingleSession.getSid().equals(string) : jingleSession instanceof IncomingJingleSession && jingleSession.getSid().equals(string))) continue;
            return jingleSession;
        }
        return null;
    }

    public List<JingleSession> getAllSessions() {
        return this.jingleSessions;
    }

    protected void rejectIncomingJingleSession(JingleSessionRequest jingleSessionRequest) {
        Jingle jingle = jingleSessionRequest.getJingle();
        Jingle jingle2 = JingleSession.createError(jingle.getPacketID(), jingle.getFrom(), jingle.getTo(), 403, "Declined");
        this.connection.send((Packet)new InfoQuery(jingle2.getFrom(), jingle2.getPacketID(), jingle2.getError()));
    }
}

