/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf;

import com.ibm.media.codec.audio.rc.RCModule;
import com.ibm.media.codec.audio.ulaw.JavaEncoder;
import com.sun.media.codec.audio.ulaw.Packetizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.Codec;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.Processor;
import javax.media.UnsupportedPlugInException;
import javax.media.control.BufferControl;
import javax.media.control.PacketSizeControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaSession;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf.AudioReceiver;

public class AudioChannel {
    private MediaLocator locator;
    private String localIpAddress;
    private String remoteIpAddress;
    private int localPort;
    private int portBase;
    private Format format;
    private Processor processor = null;
    private RTPManager[] rtpMgrs;
    private DataSource dataOutput = null;
    private AudioReceiver audioReceiver;
    private List<SendStream> sendStreams = new ArrayList<SendStream>();
    private JingleMediaSession jingleMediaSession;
    private boolean started = false;
    private Integer stateLock = Integer_.valueOf((int)0);
    private boolean failed = false;
    private static final /* synthetic */ Class class$javax$media$control$PacketSizeControl;

    public AudioChannel(MediaLocator mediaLocator, String string, String string2, int n, int n2, Format format, JingleMediaSession jingleMediaSession) {
        this.locator = mediaLocator;
        this.localIpAddress = string;
        this.remoteIpAddress = string2;
        this.localPort = n;
        this.portBase = n2;
        this.format = format;
        this.jingleMediaSession = jingleMediaSession;
    }

    public synchronized String start() {
        if (this.started) {
            return null;
        }
        String string = this.createProcessor();
        if (string != null) {
            this.started = false;
        }
        if ((string = this.createTransmitter()) != null) {
            this.processor.close();
            this.processor = null;
            this.started = false;
        } else {
            this.started = true;
        }
        this.processor.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.started) {
            return;
        }
        AudioChannel audioChannel = this;
        synchronized (audioChannel) {
            try {
                this.started = false;
                if (this.processor != null) {
                    this.processor.stop();
                    this.processor = null;
                    RTPManager[] rTPManagerArray = this.rtpMgrs;
                    int n = rTPManagerArray.length;
                    for (int i = 0; i < n; ++i) {
                        RTPManager rTPManager = rTPManagerArray[i];
                        rTPManager.removeReceiveStreamListener((ReceiveStreamListener)this.audioReceiver);
                        rTPManager.removeSessionListener((SessionListener)this.audioReceiver);
                        rTPManager.removeTargets("Session ended.");
                        rTPManager.dispose();
                    }
                    this.sendStreams.clear();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String createProcessor() {
        DataSource dataSource;
        if (this.locator == null) {
            return "Locator is null";
        }
        try {
            dataSource = Manager.createDataSource((MediaLocator)this.locator);
        }
        catch (Exception exception) {
            try {
                dataSource = Manager.createDataSource((MediaLocator)new MediaLocator("javasound://48000"));
            }
            catch (Exception exception2) {
                return "Couldn't create DataSource";
            }
        }
        try {
            this.processor = Manager.createProcessor((DataSource)dataSource);
        }
        catch (NoProcessorException noProcessorException) {
            noProcessorException.printStackTrace();
            return "Couldn't create processor";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "IOException creating processor";
        }
        boolean bl = this.waitForState(this.processor, 180);
        if (!bl) {
            return "Couldn't configure processor";
        }
        TrackControl[] trackControlArray = this.processor.getTrackControls();
        if (trackControlArray == null || trackControlArray.length < 1) {
            return "Couldn't find tracks in processor";
        }
        ContentDescriptor contentDescriptor = new ContentDescriptor("raw.rtp");
        this.processor.setContentDescriptor(contentDescriptor);
        Format format = null;
        boolean bl2 = false;
        for (int i = 0; i < trackControlArray.length; ++i) {
            if (!trackControlArray[i].isEnabled()) continue;
            Format[] formatArray = trackControlArray[i].getSupportedFormats();
            if (formatArray.length > 0) {
                Format[] formatArray2 = formatArray;
                int n = formatArray2.length;
                for (int j = 0; j < n; ++j) {
                    Format format2 = formatArray2[j];
                    if (!(format2 instanceof AudioFormat) || !this.format.matches(format2)) continue;
                    format = format2;
                }
                if (format != null) {
                    trackControlArray[i].setFormat(format);
                    System.err.println("Track " + i + " is set to transmit as:");
                    System.err.println("  " + format);
                    if (trackControlArray[i].getFormat() instanceof AudioFormat) {
                        PacketSizeControl packetSizeControl;
                        int n2 = 20;
                        Class<?> clazz = class$javax$media$control$PacketSizeControl;
                        if (clazz == null) {
                            clazz = new PacketSizeControl[0].getClass().getComponentType();
                        }
                        if ((packetSizeControl = (PacketSizeControl)this.processor.getControl(clazz.getName())) != null) {
                            try {
                                packetSizeControl.setPacketSize(this.getPacketSize(trackControlArray[i].getFormat(), n2));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                packetSizeControl.setPacketSize(80);
                            }
                        }
                        if (trackControlArray[i].getFormat().getEncoding().equals("ULAW/rtp")) {
                            Codec[] codecArray = new Codec[]{new RCModule(), new JavaEncoder(), new Packetizer()};
                            ((Packetizer)codecArray[2]).setPacketSize(160);
                            try {
                                trackControlArray[i].setCodecChain(codecArray);
                            }
                            catch (UnsupportedPlugInException unsupportedPlugInException) {
                                unsupportedPlugInException.printStackTrace();
                            }
                        }
                    }
                    bl2 = true;
                    continue;
                }
                trackControlArray[i].setEnabled(false);
                continue;
            }
            trackControlArray[i].setEnabled(false);
        }
        if (!bl2) {
            return "Couldn't set any of the tracks to a valid RTP format";
        }
        bl = this.waitForState(this.processor, 300);
        if (!bl) {
            return "Couldn't realize processor";
        }
        this.dataOutput = this.processor.getDataOutput();
        return null;
    }

    private int getPacketSize(Format format, int n) throws IllegalArgumentException {
        String string = format.getEncoding();
        if (string.equalsIgnoreCase("gsm") || string.equalsIgnoreCase("gsm/rtp")) {
            return n * 4;
        }
        if (string.equalsIgnoreCase("ULAW") || string.equalsIgnoreCase("ULAW/rtp")) {
            return n * 8;
        }
        throw new IllegalArgumentException("Unknown codec type");
    }

    private String createTransmitter() {
        PushBufferDataSource pushBufferDataSource = (PushBufferDataSource)this.dataOutput;
        PushBufferStream[] pushBufferStreamArray = pushBufferDataSource.getStreams();
        this.rtpMgrs = new RTPManager[pushBufferStreamArray.length];
        this.audioReceiver = new AudioReceiver(this, this.jingleMediaSession);
        for (int i = 0; i < pushBufferStreamArray.length; ++i) {
            try {
                BufferControl bufferControl;
                this.rtpMgrs[i] = RTPManager.newInstance();
                int n = this.portBase + 2 * i;
                InetAddress inetAddress = InetAddress.getByName(this.remoteIpAddress);
                System.out.println(this.localIpAddress);
                InetAddress inetAddress2 = InetAddress.getByName(this.localIpAddress);
                InetAddress inetAddress3 = InetAddress.getLocalHost();
                String string = inetAddress3.getHostName();
                BufferControl bufferControl2 = bufferControl = InetAddress.getAllByName(string);
                int n2 = ((InetAddress[])bufferControl2).length;
                for (int j = 0; j < n2; ++j) {
                    InetAddress inetAddress4 = bufferControl2[j];
                    if (!inetAddress4.getHostAddress().equals(this.localIpAddress)) continue;
                    inetAddress2 = inetAddress4;
                    break;
                }
                SessionAddress sessionAddress = new SessionAddress(inetAddress2, this.localPort);
                SessionAddress sessionAddress2 = new SessionAddress(inetAddress, n);
                this.rtpMgrs[i].addReceiveStreamListener((ReceiveStreamListener)this.audioReceiver);
                this.rtpMgrs[i].addSessionListener((SessionListener)this.audioReceiver);
                bufferControl2 = (BufferControl)this.rtpMgrs[i].getControl("javax.media.control.BufferControl");
                if (bufferControl2 != null) {
                    n2 = 160;
                    bufferControl2.setBufferLength((long)n2);
                }
                try {
                    this.rtpMgrs[i].initialize(sessionAddress);
                }
                catch (InvalidSessionAddressException invalidSessionAddressException) {
                    SessionAddress sessionAddress3 = new SessionAddress();
                    sessionAddress = new SessionAddress(sessionAddress3.getDataAddress(), this.localPort);
                    this.rtpMgrs[i].initialize(sessionAddress);
                }
                this.rtpMgrs[i].addTarget(sessionAddress2);
                System.err.println("Created RTP session at " + this.localPort + " to: " + this.remoteIpAddress + " " + n);
                SendStream sendStream = this.rtpMgrs[i].createSendStream(this.dataOutput, i);
                this.sendStreams.add(sendStream);
                sendStream.start();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        }
        return null;
    }

    public void setTrasmit(boolean bl) {
        Iterator<SendStream> iterator = this.sendStreams.iterator();
        while (iterator.hasNext()) {
            SendStream sendStream = iterator.next();
            try {
                if (bl) {
                    sendStream.start();
                    System.out.println("START");
                    continue;
                }
                sendStream.stop();
                System.out.println("STOP");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    Integer getStateLock() {
        return this.stateLock;
    }

    void setFailed() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor processor, int n) {
        processor.addControllerListener((ControllerListener)new StateListener());
        this.failed = false;
        if (n == 180) {
            processor.configure();
        } else if (n == 300) {
            processor.realize();
        }
        while (processor.getState() < n && !this.failed) {
            Integer n2 = this.getStateLock();
            synchronized (n2) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        return !this.failed;
    }

    public static void main(String[] stringArray) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            AudioChannel audioChannel = new AudioChannel(new MediaLocator("javasound://8000"), inetAddress.getHostAddress(), inetAddress.getHostAddress(), 7002, 7020, (Format)new AudioFormat("gsm/rtp"), null);
            AudioChannel audioChannel2 = new AudioChannel(new MediaLocator("javasound://8000"), inetAddress.getHostAddress(), inetAddress.getHostAddress(), 7020, 7002, (Format)new AudioFormat("gsm/rtp"), null);
            audioChannel.start();
            audioChannel2.start();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            audioChannel.setTrasmit(false);
            audioChannel2.setTrasmit(false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            audioChannel.setTrasmit(true);
            audioChannel2.setTrasmit(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            audioChannel.stop();
            audioChannel2.stop();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent) {
                AudioChannel.this.setFailed();
            }
            if (controllerEvent != null) {
                Integer n = AudioChannel.this.getStateLock();
                synchronized (n) {
                    AudioChannel.this.getStateLock().notifyAll();
                }
            }
        }
    }
}

