/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.packet;

import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;

public class JingleError {
    public static String NAMESPACE = "http://jabber.org/protocol/jingle#error";
    public static final XMPPError OUT_OF_ORDER = JingleError.createError("out-of-order");
    public static final XMPPError UNKNOWN_SESSION = JingleError.createError("unknown-session");
    public static final XMPPError UNSUPPORTED_CONTENT = JingleError.createError("unsupported-content");
    public static final XMPPError UNSUPPORTED_TRANSPORTS = JingleError.createError("unsupported-transports");
    public static final XMPPError NO_COMMON_PAYLOAD = JingleError.createError("unsupported-codecs");
    public static final XMPPError NEGOTIATION_ERROR = JingleError.createError("negotiation-error");
    public static final XMPPError MALFORMED_STANZA = JingleError.createError("malformed-stanza");
    private String message;

    public JingleError(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    private static XMPPError createError(String string) {
        XMPPError xMPPError = new XMPPError("cancel", 404);
        xMPPError.addError(new XMPPErrorTag(string, NAMESPACE));
        return xMPPError;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        if (this.message != null) {
            stringBuffer.append("<error type=\"cancel\">");
            stringBuffer.append("<").append(this.message).append(" xmlns=\"").append(NAMESPACE).append("\"/>");
            stringBuffer.append("</error>");
        }
    }

    public static XMPPError fromString(String string) {
        if (string != null) {
            if ((string = string.toLowerCase()).equals("out-of-order")) {
                return OUT_OF_ORDER;
            }
            if (string.equals("unknown-session")) {
                return UNKNOWN_SESSION;
            }
            if (string.equals("unsupported-content")) {
                return UNSUPPORTED_CONTENT;
            }
            if (string.equals("unsupported-transports")) {
                return UNSUPPORTED_TRANSPORTS;
            }
            if (string.equals("unsupported-codecs")) {
                return NO_COMMON_PAYLOAD;
            }
            if (string.equals("negotiation-error")) {
                return NEGOTIATION_ERROR;
            }
            if (string.equals("malformed-stanza")) {
                return MALFORMED_STANZA;
            }
        }
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getElementName() {
        return this.message;
    }

    public String getNamespace() {
        return NAMESPACE;
    }
}

