/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUserInvite;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;

public class GroupchatInvite
extends JFrame {
    private JPanel userPanel = new JPanel();
    private JLabel userLabel = new JLabel();
    private JTextField txtUser = new JTextField();
    private JPanel roomPanel = new JPanel();
    private JLabel roomLabel = new JLabel();
    private JComboBox cmbRoom = new JComboBox();
    private JPanel reasonPanel = new JPanel();
    private JLabel reasonLabel = new JLabel();
    private JTextField txtReason = new JTextField();
    private JPanel butPanel = new JPanel();
    private JButton btnCancel = new JButton();
    private JButton btnOK = new JButton();
    private Backend backend;
    private JID user;
    private JID room;

    private GroupchatInvite(Backend backend, JID jID, JID jID2, Set set) {
        this.backend = backend;
        this.user = jID;
        if (jID2 != null) {
            this.room = jID2;
        } else {
            this.initRooms(set);
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void inviteUser(Backend backend, JID jID, Set set) {
        if (set.isEmpty()) {
            Popups.errorPopup((String)I18N.gettext((String)"groupchat.You_are_not_in_any_rooms"), (String)I18N.gettext((String)"main.error.Error"));
            return;
        }
        new GroupchatInvite(backend, jID, null, set).setVisible(true);
    }

    public static void inviteToRoom(Backend backend, JID jID) {
        new GroupchatInvite(backend, null, jID, null).setVisible(true);
    }

    private void initRooms(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JID jID = (JID)iterator.next();
            this.cmbRoom.addItem(new JID(jID.getUser(), jID.getDomain()));
        }
    }

    private void init() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        I18N.setTextAndMnemonic((String)"groupchat.User", (JLabel)this.userLabel);
        JComponent jComponent = this.user != null ? new JLabel(this.user.toStringNoResource()) : this.txtUser;
        this.userLabel.setLabelFor(jComponent);
        jComponent.setPreferredSize(new Dimension(200, 21));
        this.userPanel.setLayout(new FlowLayout(2));
        this.userPanel.add((Component)this.userLabel, null);
        this.userPanel.add((Component)jComponent, null);
        I18N.setTextAndMnemonic((String)"groupchat.Room", (JLabel)this.roomLabel);
        jComponent = this.room != null ? new JLabel(this.room.toString()) : this.cmbRoom;
        this.roomLabel.setLabelFor(jComponent);
        jComponent.setPreferredSize(new Dimension(200, 21));
        this.roomPanel.setLayout(new FlowLayout(2));
        this.roomPanel.add((Component)this.roomLabel, null);
        this.roomPanel.add((Component)jComponent, null);
        I18N.setTextAndMnemonic((String)"groupchat.Reason", (JLabel)this.reasonLabel);
        this.reasonLabel.setLabelFor(this.txtReason);
        this.txtReason.setPreferredSize(new Dimension(200, 21));
        this.reasonPanel.setLayout(new FlowLayout(2));
        this.reasonPanel.add((Component)this.reasonLabel, null);
        this.reasonPanel.add((Component)this.txtReason, null);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatInvite.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.btnCancel, (Action)abstractAction);
        this.btnOK.setText(I18N.gettext((String)"OK"));
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatInvite.this.btnOK_actionPerformed(actionEvent);
            }
        });
        this.butPanel.add((Component)this.btnOK, null);
        this.butPanel.add((Component)this.btnCancel, null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.userPanel);
        this.getContentPane().add(this.roomPanel);
        this.getContentPane().add(this.reasonPanel);
        this.getContentPane().add(this.butPanel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        if (this.user == null) {
            try {
                this.user = JID.checkedJIDFromString((String)this.txtUser.getText());
            }
            catch (InstantiationException instantiationException) {
                Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"groupchat.{0}_is_an_invalid_user_name"), this.user), (String)I18N.gettext((String)"groupchat.invalid_user_name"));
                return;
            }
        }
        if (this.room == null) {
            this.room = (JID)this.cmbRoom.getSelectedItem();
        }
        this.backend.send((Packet)new Message(null, this.room, (XExtension)new XMUCUserInvite(this.user, this.txtReason.getText())));
        this.dispose();
    }
}

