/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.handlers;

import java.util.ArrayList;
import java.util.List;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.groupchat.Bookmarks;
import nu.fw.jeti.plugins.groupchat.elements.Conference;
import nu.fw.jeti.plugins.groupchat.elements.PrivateBookmarkExtension;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class PrivateBookmarkHandler
extends ExtensionHandler {
    private List urls;
    private List conferences;
    private String name;
    private JID jid;
    private String nick;
    private String password;
    private boolean autoJoin;
    private Bookmarks bookmarks;

    public PrivateBookmarkHandler(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
    }

    public void startHandling(Attributes attributes) {
        this.jid = null;
        this.name = null;
        this.autoJoin = false;
        this.nick = null;
        this.password = null;
        this.urls = new ArrayList(10);
        this.conferences = new ArrayList(10);
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("conference")) {
            this.name = attributes.getValue("name");
            try {
                this.jid = JID.checkedJIDFromString((String)attributes.getValue("jid"));
            }
            catch (InstantiationException instantiationException) {
                Log.notParsedXML((String)"bookmark, invalid JID");
            }
            String string2 = attributes.getValue("autojoin");
            this.autoJoin = string2 != null && string2.equals("1");
        } else if (string.equals("url")) {
            this.urls.add(new String[]{attributes.getValue("name"), attributes.getValue("url")});
        }
    }

    public void endElement(String string) {
        if (string.equals("conference")) {
            if (this.jid != null) {
                this.conferences.add(new Conference(this.name, this.jid, this.autoJoin, this.nick, this.password));
            }
            this.jid = null;
            string = null;
            this.autoJoin = false;
            this.nick = null;
            this.password = null;
        } else if (string.equals("nick")) {
            this.nick = this.getText();
        } else if (string.equals("password")) {
            this.password = this.getText();
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        this.jid = null;
        this.name = null;
        this.autoJoin = false;
        this.nick = null;
        this.password = null;
        return new PrivateBookmarkExtension(this.urls, this.conferences, this.bookmarks);
    }
}

