/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.handlers;

import java.util.LinkedList;
import java.util.List;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.groupchat.elements.IQMUC;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public abstract class XMUCHandler
extends ExtensionHandler {
    private XData xdata;
    private List items;
    private int errorCode;
    private String errorDescription;

    public void startHandling(Attributes attributes) {
        this.reset();
    }

    private void reset() {
        this.xdata = null;
        this.items = null;
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("item")) {
            if (this.items == null) {
                this.items = new LinkedList();
            }
            try {
                JID jID = JID.checkedJIDFromString((String)attributes.getValue("jid"));
                this.items.add(new XMUCUser(attributes.getValue("affiliation"), attributes.getValue("role"), null, jID, 0));
            }
            catch (InstantiationException instantiationException) {
                Log.xmlParseException((Exception)instantiationException);
            }
        } else if (string.equals("error")) {
            try {
                this.errorCode = Integer.parseInt(attributes.getValue("code"));
            }
            catch (NumberFormatException numberFormatException) {
                Log.notParsedXML((String)("XMUC#Handler " + string + this.getText()));
            }
        }
    }

    public void endElement(String string) {
        if (!string.equals("reason") && string.equals("error")) {
            this.errorDescription = this.getText();
        }
        this.clearCurrentChars();
    }

    public void addExtension(Extension extension) {
        if (extension instanceof XData) {
            this.xdata = (XData)extension;
        }
    }

    public abstract String getInstance();

    public Extension build() {
        IQMUC iQMUC = this.xdata != null ? new IQMUC(this.getInstance(), this.xdata) : new IQMUC(this.getInstance(), this.items, this.errorCode, this.errorDescription);
        this.reset();
        return iQMUC;
    }
}

