/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchatalerter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.MessageBuilder;
import nu.fw.jeti.jabber.elements.XDelay;

class MessageAndDate {
    private Message message;
    private long time;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'hh:mm:ss");

    public MessageAndDate(Message message) {
        this.message = message;
        this.time = System.currentTimeMillis();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Message getMessage() {
        MessageBuilder messageBuilder = new MessageBuilder();
        messageBuilder.body = this.message.getBody();
        messageBuilder.from = this.message.getFrom();
        messageBuilder.to = this.message.getTo();
        messageBuilder.thread = this.message.getThread();
        messageBuilder.type = this.message.getType();
        boolean bl = false;
        if (this.message.hasExtensions()) {
            Iterator iterator = this.message.getExtensions();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                messageBuilder.addExtension(extension);
                if (!(extension instanceof XDelay)) continue;
                bl = true;
            }
        }
        if (!bl) {
            messageBuilder.addExtension((Extension)new XDelay(dateFormat.format(new Date(this.time)), this.message.getFrom()));
        }
        return (Message)messageBuilder.build();
    }
}

