/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.StyleSheet;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.xhtml.fontchooser.FontPanel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private FontPanel fontPanel = new FontPanel();
    private StyleSheet styleSheet = new StyleSheet();

    public PrefPanel(Backend backend) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        gridBagConstraints.gridwidth = 0;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = Preferences.getInteger((String)"xhtml", (String)"foreground", (int)0);
        if (n != 0) {
            StyleConstants.setForeground(simpleAttributeSet, new Color(n));
        }
        if ((n = Preferences.getInteger((String)"xhtml", (String)"background", (int)0)) != 0) {
            StyleConstants.setBackground(simpleAttributeSet, new Color(n));
        }
        if ((n = Preferences.getInteger((String)"xhtml", (String)"font-size", (int)0)) != 0) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        StyleConstants.setBold(simpleAttributeSet, Preferences.getBoolean((String)"xhtml", (String)"bold", (boolean)false));
        StyleConstants.setItalic(simpleAttributeSet, Preferences.getBoolean((String)"xhtml", (String)"italic", (boolean)false));
        StyleConstants.setFontFamily(simpleAttributeSet, Preferences.getString((String)"xhtml", (String)"font-family", (String)"Arial"));
        this.fontPanel.setAttributes(simpleAttributeSet);
        this.add(new JLabel(I18N.gettext((String)"xhtml.The_font_used_when_sending_messages")), gridBagConstraints);
        this.add(this.fontPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public void savePreferences() {
        Color color;
        AttributeSet attributeSet = this.fontPanel.getAttributes();
        if (attributeSet.isDefined(StyleConstants.Foreground)) {
            color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
            Preferences.putInteger((String)"xhtml", (String)"foreground", (int)color.getRGB());
        }
        if (attributeSet.isDefined(StyleConstants.Background)) {
            color = (Color)attributeSet.getAttribute(StyleConstants.Background);
            Preferences.putInteger((String)"xhtml", (String)"background", (int)color.getRGB());
        }
        if (attributeSet.isDefined(StyleConstants.FontFamily)) {
            Preferences.putString((String)"xhtml", (String)"font-family", (String)StyleConstants.getFontFamily(attributeSet));
        }
        if (attributeSet.isDefined(StyleConstants.FontSize)) {
            Preferences.putInteger((String)"xhtml", (String)"font-size", (int)StyleConstants.getFontSize(attributeSet));
        }
        Preferences.putBoolean((String)"xhtml", (String)"bold", (boolean)StyleConstants.isBold(attributeSet));
        Preferences.putBoolean((String)"xhtml", (String)"italic", (boolean)StyleConstants.isItalic(attributeSet));
    }
}

