/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.vcard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.vcard.VCard;
import nu.fw.jeti.plugins.vcard.VCardEdit;
import nu.fw.jeti.plugins.vcard.VCardHandler;
import nu.fw.jeti.util.I18N;

public class Plugin
extends JFrame
implements Plugins {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "vcard.shows_contact_details";
    public static final String MIN_JETI_VERSION = "0.6";
    public static final String NAME = "vcard";
    public static final String ABOUT = "by E.S. de Boer";
    private static JMenuItem menuitem;

    public static void init(final Backend backend) {
        backend.getMain().addToRosterMenu(I18N.gettext((String)"vcard.Show_Details"), new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                backend.send((Packet)new InfoQuery(jIDStatus.getJID(), "get", (IQExtension)new VCard()));
            }
        });
        menuitem = new JMenuItem(I18N.gettext((String)"vcard.Edit_Details"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                backend.send(new InfoQuery("get", (IQExtension)new VCard()), new IQResultListener(){

                    public void iqResult(InfoQuery infoQuery) {
                        JID jID;
                        IQExtension iQExtension = infoQuery.getIQExtension();
                        if (iQExtension instanceof VCard) {
                            ((VCard)iQExtension).execute(infoQuery, backend);
                        } else if (infoQuery.getType().equals("result") && (jID = infoQuery.getFrom()).equals(backend.getMyJID())) {
                            new VCardEdit(new HashMap(), new HashMap(), new LinkedList(), new LinkedList(), backend);
                        }
                    }
                }, 100);
            }
        });
        backend.getMain().addToMenu(menuitem);
        backend.addExtensionHandler("vcard-temp", (ExtensionHandler)new VCardHandler());
    }

    public static void unload(Backend backend) {
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)"vcard.Show_Details"));
        backend.getMain().removeFromMenu(menuitem);
        menuitem = null;
        backend.removeExtensionHandler("vcard-temp");
    }

    public void unload() {
    }
}

