/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.event.BasicSpellCheckEvent;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.WordTokenizer;
import com.swabunga.util.VectorUtility;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SpellChecker {
    public static final int SPELLCHECK_OK = -1;
    public static final int SPELLCHECK_CANCEL = -2;
    private Vector eventListeners = new Vector();
    private Vector dictionaries = new Vector();
    private Configuration config = Configuration.getConfiguration();

    public SpellChecker() {
    }

    public SpellChecker(SpellDictionary spellDictionary) {
        this();
        this.addDictionary(spellDictionary);
    }

    public SpellChecker(SpellDictionary spellDictionary, int n) {
        this(spellDictionary);
        this.config.setInteger("SPELL_THRESHOLD", n);
    }

    public void addDictionary(SpellDictionary spellDictionary) {
        if (spellDictionary == null) {
            throw new IllegalArgumentException("dictionary must be non-null");
        }
        this.dictionaries.addElement(spellDictionary);
    }

    public void addSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.addElement(spellCheckListener);
    }

    public void removeSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.removeElement(spellCheckListener);
    }

    protected void fireSpellCheckEvent(SpellCheckEvent spellCheckEvent) {
        for (int i = this.eventListeners.size() - 1; i >= 0; --i) {
            ((SpellCheckListener)this.eventListeners.elementAt(i)).spellingError(spellCheckEvent);
        }
    }

    private static final boolean isDigitWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isINETWord(String string) {
        String string2 = string.toLowerCase();
        return string2.startsWith("http://") || string2.startsWith("www.") || string2.startsWith("ftp://") || string2.startsWith("https://") || string2.startsWith("ftps://");
    }

    private static final boolean isUpperCaseWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isMixedCaseWord(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = Character.isUpperCase(string.charAt(0));
        if (bl && bl2 && n > 1) {
            bl2 = Character.isUpperCase(string.charAt(1));
        }
        if (bl2) {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                return true;
            }
        } else {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isUpperCase(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean fireAndHandleEvent(WordTokenizer wordTokenizer, SpellCheckEvent spellCheckEvent) {
        this.fireSpellCheckEvent(spellCheckEvent);
        return false;
    }

    private boolean isCorrect(String string) {
        Enumeration enumeration = this.dictionaries.elements();
        while (enumeration.hasMoreElements()) {
            SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
            if (!spellDictionary.isCorrect(string)) continue;
            return true;
        }
        return false;
    }

    public List getSuggestions(String string, int n) {
        Vector vector = new Vector();
        Enumeration enumeration = this.dictionaries.elements();
        while (enumeration.hasMoreElements()) {
            SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
            VectorUtility.addAll(vector, spellDictionary.getSuggestions(string, n), false);
        }
        return vector;
    }

    public final int checkSpelling(WordTokenizer wordTokenizer) {
        int n = 0;
        boolean bl = false;
        while (wordTokenizer.hasMoreWords() && !bl) {
            String string = wordTokenizer.nextWord();
            if (this.isCorrect(string) || this.config.getBoolean("SPELL_IGNOREMIXEDCASE") && SpellChecker.isMixedCaseWord(string, wordTokenizer.isNewSentence()) || this.config.getBoolean("SPELL_IGNOREUPPERCASE") && SpellChecker.isUpperCaseWord(string) || this.config.getBoolean("SPELL_IGNOREDIGITWORDS") && SpellChecker.isDigitWord(string) || this.config.getBoolean("SPELL_IGNOREINTERNETADDRESS") && SpellChecker.isINETWord(string)) continue;
            ++n;
            BasicSpellCheckEvent basicSpellCheckEvent = new BasicSpellCheckEvent(string, null, wordTokenizer.getCurrentWordPosition());
            bl = this.fireAndHandleEvent(wordTokenizer, basicSpellCheckEvent);
        }
        if (bl) {
            return -2;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }
}

