/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.spell;

import com.swabunga.spell.engine.DoubleMeta;
import com.swabunga.spell.engine.GenericTransformator;
import com.swabunga.spell.engine.Transformator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class BuildDictionaryFile {
    private static String wordlist;
    private static String phonet;
    private static String dico;
    private static String encoding;

    public static final void main(String[] stringArray) throws Exception {
        if (stringArray.length == 3) {
            phonet = stringArray[0];
            wordlist = stringArray[1];
            dico = stringArray[2];
        } else if (stringArray.length == 2) {
            phonet = null;
            wordlist = stringArray[0];
            dico = stringArray[1];
        } else {
            System.out.println("Usage:\n BuildDictionaryFile [phonetfile] [wordfile] [outputfile]\nOr\n BuildDictionaryFile [wordfile] [outputfile]");
            System.out.println("Example:\n java -Xms64m -Xmx128m -classpath spell.jar:. BuildDictionaryFile fr_phonet.dat french.words francais.dico");
            System.exit(0);
        }
        new BuildDictionaryFile().buildFile();
    }

    private void buildFile() throws Exception {
        Object object;
        String string;
        int n = 0;
        Transformator transformator = phonet == null ? new DoubleMeta() : new GenericTransformator(new File(phonet), encoding);
        BufferedReader bufferedReader = encoding == null ? new BufferedReader(new FileReader(wordlist)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wordlist), encoding));
        File file = new File(dico);
        if (file.exists()) {
            System.out.println("WARNING: collision!");
        }
        System.out.println("reading...");
        ArrayList<CodeAndWord> arrayList = new ArrayList<CodeAndWord>();
        while ((string = bufferedReader.readLine()) != null) {
            object = transformator.transform(string);
            if (!"".equals(object)) {
                arrayList.add(new CodeAndWord((String)object, string));
            }
            ++n;
        }
        bufferedReader.close();
        System.out.println("Words: " + n);
        System.out.println("sorting...");
        this.quickSort(arrayList, 0, arrayList.size() - 1);
        object = encoding == null ? new BufferedWriter(new FileWriter(file)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        for (int i = 0; i < arrayList.size(); ++i) {
            CodeAndWord codeAndWord = (CodeAndWord)arrayList.get(i);
            ((Writer)object).write(codeAndWord.code + "*" + codeAndWord.word);
            ((BufferedWriter)object).newLine();
        }
        ((BufferedWriter)object).close();
        System.out.println("finished");
    }

    private void quickSort(List list, int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(list, n, n2);
            if (n3 == n2) {
                --n3;
            }
            this.quickSort(list, n, n3);
            this.quickSort(list, n3 + 1, n2);
        }
    }

    private int partition(List list, int n, int n2) {
        CodeAndWord codeAndWord = (CodeAndWord)list.get(n);
        while (true) {
            if (((CodeAndWord)list.get(n2)).compareTo(codeAndWord) >= 0 && n < n2) {
                --n2;
                continue;
            }
            while (((CodeAndWord)list.get(n)).compareTo(codeAndWord) < 0 && n < n2) {
                ++n;
            }
            if (n >= n2) break;
            Object e = list.get(n);
            list.set(n, list.get(n2));
            list.set(n2, e);
        }
        return n2;
    }

    static {
        encoding = "ISO-8859-1";
    }

    private static class CodeAndWord {
        public String code;
        public String word;

        public CodeAndWord(String string, String string2) {
            this.code = string;
            this.word = string2;
        }

        public int compareTo(CodeAndWord codeAndWord) {
            int n = this.code.compareTo(codeAndWord.code);
            if (n != 0) {
                return n;
            }
            return this.word.compareTo(codeAndWord.word);
        }
    }
}

