/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.messagelog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.plugins.messagelog.IndexOldLogs;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Utils;

public class MessageLogWindow
extends JFrame {
    private JSplitPane splitPane = new JSplitPane();
    private JList list;
    private StringBuffer text = new StringBuffer();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTextArea jTextArea1;
    private JTextField txtSearch = new JTextField();
    private Map logs;
    private Date[] dates;
    private int logNumber = 0;
    private int logPosition = 0;

    public MessageLogWindow(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
        if (jIDStatus == null) {
            return;
        }
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(jIDStatus.getNick());
        this.splitPane.setBorder(null);
        this.jTextArea1 = new JTextArea(this.text.toString());
        this.jTextArea1.setEditable(false);
        this.splitPane.add((Component)this.jScrollPane1, "right");
        this.splitPane.add((Component)this.jScrollPane2, "left");
        this.getContentPane().add((Component)this.splitPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 2, 0));
        jPanel2.setBorder(null);
        JButton jButton = new JButton();
        I18N.setTextAndMnemonic((String)"messagelog.Search", (AbstractButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageLogWindow.this.search(0, 0);
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton();
        I18N.setTextAndMnemonic((String)"messagelog.Search_Next", (AbstractButton)jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageLogWindow.this.search(MessageLogWindow.this.logNumber, MessageLogWindow.this.logPosition);
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton();
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Close")){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageLogWindow.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)jButton, (Action)abstractAction);
        jPanel2.add(jButton);
        jPanel.add((Component)this.txtSearch, "Center");
        jPanel.add((Component)jPanel2, "East");
        this.getContentPane().add((Component)jPanel, "South");
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.setSize(600, 600);
        this.splitPane.setDividerLocation(150);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        IndexOldLogs.index(jIDStatus, this, jIDStatusGroup);
    }

    public void addData(final Map map) {
        this.logs = map;
        this.dates = map.keySet().toArray(new Date[map.size()]);
        Arrays.sort(this.dates, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object2).compareTo(object);
            }
        });
        this.list = new JList<Date>(this.dates);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MessageLogWindow.this.list.getSelectedValue() != null) {
                    MessageLogWindow.this.jTextArea1.setText((String)map.get(MessageLogWindow.this.list.getSelectedValue()));
                }
                MessageLogWindow.this.jTextArea1.setCaretPosition(0);
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){
            DateFormat dateFormat = DateFormat.getDateTimeInstance();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setText(this.dateFormat.format(object));
                return jLabel;
            }
        });
        this.jScrollPane2.getViewport().add(this.list);
    }

    private void search(int n, int n2) {
        String string = this.txtSearch.getText();
        if (string.equals("")) {
            return;
        }
        for (int i = n; i < this.dates.length; ++i) {
            Date date = this.dates[i];
            String string2 = (String)this.logs.get(date);
            int n3 = string2.indexOf(string, n2);
            if (n3 != -1) {
                this.list.setSelectedIndex(i);
                this.jTextArea1.requestFocus();
                this.jTextArea1.setCaretPosition(n3);
                int n4 = n3 + string.length();
                this.jTextArea1.moveCaretPosition(n4);
                this.logNumber = i;
                this.logPosition = n4;
                return;
            }
            n2 = 0;
        }
        this.logPosition = 0;
        this.logNumber = 0;
        if (JOptionPane.showConfirmDialog(this, MessageFormat.format(I18N.gettext((String)"main.popup.{0}_not_found_until_the_end_of_this_file,_start_again_from_the_beginning?"), string)) == 0) {
            this.search(0, 0);
        }
    }
}

