/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.header;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public class MessageHeader
implements MessageHeaderInterface {
    private static Logger logger = Logger.getLogger("de.javawi.stun.header.MessageHeader");
    MessageHeaderInterface.MessageHeaderType type;
    byte[] id = new byte[16];
    TreeMap<MessageAttributeInterface.MessageAttributeType, MessageAttribute> ma = new TreeMap();

    public MessageHeader() {
    }

    public MessageHeader(MessageHeaderInterface.MessageHeaderType messageHeaderType) {
        this.setType(messageHeaderType);
    }

    public void setType(MessageHeaderInterface.MessageHeaderType messageHeaderType) {
        this.type = messageHeaderType;
    }

    public static int typeToInteger(MessageHeaderInterface.MessageHeaderType messageHeaderType) {
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.BindingRequest) {
            return 1;
        }
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.BindingResponse) {
            return 257;
        }
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.BindingErrorResponse) {
            return 273;
        }
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.SharedSecretRequest) {
            return 2;
        }
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.SharedSecretResponse) {
            return 258;
        }
        if (messageHeaderType == MessageHeaderInterface.MessageHeaderType.SharedSecretErrorResponse) {
            return 274;
        }
        return -1;
    }

    public void setTransactionID(byte[] byArray) {
        System.arraycopy(byArray, 0, this.id, 0, 4);
    }

    public void generateTransactionID() throws UtilityException {
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 2, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 4, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 6, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 8, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 10, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 12, 2);
        System.arraycopy(Utility.IntegerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 14, 2);
    }

    public byte[] getTransactionID() {
        return this.id;
    }

    public boolean equalTransactionID(MessageHeader messageHeader) {
        byte[] byArray = messageHeader.getTransactionID();
        if (byArray.length != 16) {
            return false;
        }
        return byArray[0] == this.id[0] && byArray[1] == this.id[1] && byArray[2] == this.id[2] && byArray[3] == this.id[3] && byArray[4] == this.id[4] && byArray[5] == this.id[5] && byArray[6] == this.id[6] && byArray[7] == this.id[7] && byArray[8] == this.id[8] && byArray[9] == this.id[9] && byArray[10] == this.id[10] && byArray[11] == this.id[11] && byArray[12] == this.id[12] && byArray[13] == this.id[13] && byArray[14] == this.id[14] && byArray[15] == this.id[15];
    }

    public void addMessageAttribute(MessageAttribute messageAttribute) {
        this.ma.put(messageAttribute.getType(), messageAttribute);
    }

    public MessageAttribute getMessageAttribute(MessageAttributeInterface.MessageAttributeType messageAttributeType) {
        return this.ma.get((Object)messageAttributeType);
    }

    public byte[] getBytes() throws UtilityException {
        Object object;
        int n = 20;
        Iterator<MessageAttributeInterface.MessageAttributeType> iterator = this.ma.keySet().iterator();
        while (iterator.hasNext()) {
            object = this.ma.get((Object)iterator.next());
            n += ((MessageAttribute)object).getLength();
        }
        object = new byte[n];
        System.arraycopy(Utility.IntegerToTwoBytes(MessageHeader.typeToInteger(this.type)), 0, object, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(n - 20), 0, object, 2, 2);
        System.arraycopy(this.id, 0, object, 4, 16);
        int n2 = 20;
        iterator = this.ma.keySet().iterator();
        while (iterator.hasNext()) {
            MessageAttribute messageAttribute = this.ma.get((Object)iterator.next());
            System.arraycopy(messageAttribute.getBytes(), 0, object, n2, messageAttribute.getLength());
            n2 += messageAttribute.getLength();
        }
        return object;
    }

    public int getLength() throws UtilityException {
        return this.getBytes().length;
    }

    public static MessageHeader parseHeader(byte[] byArray) throws MessageHeaderParsingException, MessageAttributeParsingException {
        try {
            MessageHeader messageHeader = new MessageHeader();
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 0, byArray2, 0, 2);
            int n = Utility.TwoBytesToInteger(byArray2);
            switch (n) {
                case 1: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                    logger.finer("Binding Request received.");
                    break;
                }
                case 257: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.BindingResponse);
                    logger.finer("Binding Response received.");
                    break;
                }
                case 273: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.BindingErrorResponse);
                    logger.finer("Binding Error Response received.");
                    break;
                }
                case 2: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretRequest);
                    logger.finer("Shared Secret Request received.");
                    break;
                }
                case 258: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretResponse);
                    logger.finer("Shared Secret Response received.");
                    break;
                }
                case 274: {
                    messageHeader.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretErrorResponse);
                    logger.finer("Shared Secret Error Response received.");
                    break;
                }
                default: {
                    throw new MessageHeaderParsingException("Message type " + n + "is not supported");
                }
            }
            byte[] byArray3 = new byte[2];
            System.arraycopy(byArray, 2, byArray3, 0, 2);
            int n2 = Utility.TwoBytesToInteger(byArray3);
            System.arraycopy(byArray, 4, messageHeader.id, 0, 16);
            int n3 = 20;
            while (n2 > 0) {
                byte[] byArray4 = new byte[n2];
                System.arraycopy(byArray, n3, byArray4, 0, n2);
                MessageAttribute messageAttribute = MessageAttribute.parseCommonHeader(byArray4);
                if (messageAttribute.getType() != MessageAttributeInterface.MessageAttributeType.Dummy) {
                    messageHeader.addMessageAttribute(messageAttribute);
                }
                n2 -= messageAttribute.getLength();
                n3 += messageAttribute.getLength();
            }
            return messageHeader;
        }
        catch (UtilityException utilityException) {
            throw new MessageHeaderParsingException("Parsing error");
        }
    }
}

