/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;

public class Candidate
implements Comparable {
    private DatagramSocket socket;
    private CandidateType type;
    private short componentId;
    private int priority;
    private int foundationId;
    private int network;
    private Candidate base;
    private boolean isInUse;
    private Address address;
    private int port;

    public Candidate(Address address, short s, int n) throws SocketException, UnknownHostException, UtilityException {
        this.address = address;
        this.network = n;
        this.socket = new DatagramSocket(0, address.getInetAddress());
        this.port = this.socket.getPort();
        this.socket.close();
        this.type = CandidateType.Local;
        this.setComponentId(s);
        this.priority = 0;
        this.base = this;
        this.isInUse = false;
    }

    public Candidate(Address address, CandidateType candidateType, short s, Candidate candidate, int n) throws SocketException, UnknownHostException, UtilityException {
        this.address = address;
        this.network = n;
        this.socket = new DatagramSocket(0, candidate.getAddress().getInetAddress());
        this.type = candidateType;
        this.setComponentId(s);
        this.priority = 0;
        this.base = candidate;
        this.isInUse = false;
    }

    public void setBase(Candidate candidate) {
        this.base = candidate;
    }

    public Candidate getBase() {
        return this.base;
    }

    public CandidateType getCandidateType() {
        return this.type;
    }

    public void setCandidateType(CandidateType candidateType) {
        this.type = candidateType;
    }

    public void setComponentId(short s) {
        if (s < 1 || s > 256) {
            throw new IllegalArgumentException(s + " is not between 1 and 256 inclusive.");
        }
        this.componentId = s;
    }

    public short getComponentId() {
        return this.componentId;
    }

    public void setFoundationId(int n) {
        this.foundationId = n;
    }

    public int getFoundationId() {
        return this.foundationId;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public Address getAddress() throws UtilityException {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setInUse(boolean bl) {
        this.isInUse = bl;
    }

    public boolean getInUse() {
        return this.isInUse;
    }

    public int compareTo(Object object) {
        Candidate candidate = (Candidate)object;
        return candidate.getPriority() - this.getPriority();
    }

    public int getNetwork() {
        return this.network;
    }

    public CandidateType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return ((Candidate)object).socket.equals(this.socket) && ((Candidate)object).base.equals(this.base);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CandidateType
    extends Enum<CandidateType> {
        public static final /* enum */ CandidateType Local = new CandidateType("Local", 0);
        public static final /* enum */ CandidateType ServerReflexive = new CandidateType("ServerReflexive", 1);
        public static final /* enum */ CandidateType PeerReflexive = new CandidateType("PeerReflexive", 2);
        public static final /* enum */ CandidateType Relayed = new CandidateType("Relayed", 3);
        private static final /* synthetic */ CandidateType[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$de$javawi$jstun$test$demo$ice$Candidate$CandidateType;

        public static CandidateType[] values() {
            return (CandidateType[])$VALUES.clone();
        }

        public static CandidateType valueOf(String string) {
            Class<?> clazz = class$de$javawi$jstun$test$demo$ice$Candidate$CandidateType;
            if (clazz == null) {
                clazz = class$de$javawi$jstun$test$demo$ice$Candidate$CandidateType = new CandidateType[0].getClass().getComponentType();
            }
            return (CandidateType)Enum.valueOf((Class)clazz, (String)string);
        }

        private CandidateType(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new CandidateType[]{Local, ServerReflexive, PeerReflexive, Relayed};
            CandidateType[] candidateTypeArray = CandidateType.values();
            Class<?> clazz = class$de$javawi$jstun$test$demo$ice$Candidate$CandidateType;
            if (clazz == null) {
                clazz = class$de$javawi$jstun$test$demo$ice$Candidate$CandidateType = new CandidateType[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])candidateTypeArray, (Class)clazz);
        }
    }
}

