/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICENegociator {
    private static final int LOCAL_PREFERENCE = 0;
    private static final int SERVER_REFLEXIVE_PREFERENCE = 42;
    private static final int PEER_REFLEXIVE_PREFERENCE = 84;
    private static final int RELAYED_PREFERENCE = 126;
    private String server;
    private int port;
    private short componentId;
    List candidates;
    private Candidate publicCandidate;
    List resolvingList;

    public ICENegociator(short s) {
        this.server = "igniterealtime.org";
        this.port = 3478;
        this.publicCandidate = null;
        this.resolvingList = new ArrayList();
        this.componentId = s;
        this.candidates = new ArrayList();
    }

    public ICENegociator(short s, String string, int n) {
        System.out.println("icenegotiater started");
        this.server = "igniterealtime.org";
        this.port = 3478;
        this.publicCandidate = null;
        this.resolvingList = new ArrayList();
        this.server = string;
        this.port = n;
        this.componentId = s;
        this.candidates = new ArrayList();
        System.out.println(this.server);
    }

    public void gatherCandidateAddresses() {
        this.candidates = new ArrayList();
        int n = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    final InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    final Candidate candidate = new Candidate(new Address(inetAddress.getAddress()), this.componentId, n++);
                    final int n2 = n;
                    candidate.setCandidateType(Candidate.CandidateType.PeerReflexive);
                    this.candidates.add(candidate);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            DiscoveryTest discoveryTest = new DiscoveryTest(inetAddress, ICENegociator.this.server, ICENegociator.this.port);
                            DiscoveryInfo discoveryInfo = null;
                            try {
                                discoveryInfo = discoveryTest.quickTest();
                                if (discoveryInfo.getPublicIP() != null) {
                                    Candidate candidate2 = new Candidate(new Address(discoveryInfo.getPublicIP().getAddress()), Candidate.CandidateType.ServerReflexive, ICENegociator.this.componentId, candidate, n2);
                                    candidate2.setComponentId(ICENegociator.this.componentId);
                                    ICENegociator.this.publicCandidate = candidate2;
                                    ICENegociator.this.candidates.add(candidate2);
                                    ICENegociator.this.prioritizeCandidates();
                                }
                            }
                            catch (UtilityException utilityException) {
                                utilityException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            catch (MessageAttributeException messageAttributeException) {
                                messageAttributeException.printStackTrace();
                            }
                            catch (MessageHeaderParsingException messageHeaderParsingException) {
                                messageHeaderParsingException.printStackTrace();
                            }
                            ICENegociator.this.resolvingList.remove(this);
                        }
                    };
                    Thread thread = new Thread(runnable, candidate.getAddress().getInetAddress().getHostAddress());
                    this.resolvingList.add(runnable);
                    thread.start();
                }
            }
            this.prioritizeCandidates();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void prioritizeCandidates() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Candidate candidate : this.candidates) {
            Object object = candidate.getCandidateType();
            if (object == Candidate.CandidateType.Local) {
                ++n;
                continue;
            }
            if (object == Candidate.CandidateType.ServerReflexive) {
                ++n2;
                continue;
            }
            if (object == Candidate.CandidateType.PeerReflexive) {
                ++n3;
                continue;
            }
            if (object != Candidate.CandidateType.Relayed) continue;
            ++n4;
        }
        int n5 = 0;
        for (Object object : this.candidates) {
            ++n5;
            int n6 = 0;
            int n7 = 0;
            short s = 0;
            Candidate.CandidateType candidateType = ((Candidate)object).getCandidateType();
            if (candidateType == Candidate.CandidateType.Local) {
                n6 = 0;
                n7 = n--;
            } else if (candidateType == Candidate.CandidateType.ServerReflexive) {
                n6 = 42;
                n7 = n2--;
            } else if (candidateType == Candidate.CandidateType.PeerReflexive) {
                n6 = 84;
                n7 = n3--;
            } else if (candidateType == Candidate.CandidateType.Relayed) {
                n6 = 126;
                n7 = n4--;
            }
            s = ((Candidate)object).getComponentId();
            int n8 = 26 * n6 + 10 * n7 + s;
            ((Candidate)object).setPriority(n8);
        }
        System.out.println(n5);
    }

    public List<Candidate> getSortedCandidates() {
        Vector<Candidate> vector = new Vector<Candidate>(this.candidates);
        Collections.sort(vector);
        return vector;
    }

    public static void main(String[] stringArray) {
        String object = "";
        try {
            int n = 0;
            long l = System.currentTimeMillis();
            for (int i = 0; i < 3; ++i) {
                ICENegociator iCENegociator = new ICENegociator(1, "stun.xten.net", 3478);
                iCENegociator.gatherCandidateAddresses();
                while (iCENegociator.resolvingList.size() > 0) {
                    Thread.sleep(300L);
                }
                iCENegociator.prioritizeCandidates();
                for (Candidate candidate : iCENegociator.getSortedCandidates()) {
                    try {
                        System.out.println(new StringBuffer().append(candidate.getAddress().getInetAddress()).append("|").append(candidate.getBase().getAddress().getInetAddress()).append(" p:").append(candidate.getPriority()));
                    }
                    catch (UtilityException utilityException) {
                        utilityException.printStackTrace();
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace();
                    }
                }
                Candidate candidate = iCENegociator.getSortedCandidates().get(0);
                String object22 = new StringBuffer().append("C: ").append(candidate.getAddress().getInetAddress()).append("|").append(candidate.getBase().getAddress().getInetAddress()).append(" p:").append(candidate.getPriority()).toString();
                if (object.equals("")) {
                    object = object22;
                }
                if (!object.equals(object22)) {
                    ++n;
                }
                object = object22;
                Thread.sleep(10L);
            }
            System.out.println(new StringBuffer().append("Errors: ").append(n).append(" Time:").append(System.currentTimeMillis() - l).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Candidate getPublicCandidate() {
        return this.publicCandidate;
    }
}

