/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenuItem;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.IncomingJingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleManager;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleSessionRequest;
import nu.fw.jeti.plugins.jingle.jingle.OutgoingJingleSession;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionRequestListener;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf.JmfMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jspeex.SpeexMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.multi.MultiMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.nat.ICETransportManager;
import nu.fw.jeti.plugins.jingle.jingle.nat.RTPBridge;
import nu.fw.jeti.plugins.jingle.jingle.nat.STUN;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.provider.JingleContentDescriptionProvider;
import nu.fw.jeti.plugins.jingle.provider.JingleContentInfoProvider;
import nu.fw.jeti.plugins.jingle.provider.JingleProvider;
import nu.fw.jeti.plugins.jingle.provider.JingleTransportProvider;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.2";
    public static final String DESCRIPTION = "jingle.VOIP";
    public static final String MIN_JETI_VERSION = "0.8";
    public static final String NAME = "jingle";
    public static final String ABOUT = "Based on the Jingle implementation of Smack by Jive software";
    private static Plugin plugin;
    private JingleManager manager;
    private Map<JID, JingleSession> sessions = new HashMap<JID, JingleSession>(0);
    private JMenuItem endVoiceMenu = new JMenuItem("End voice calls");
    private static final /* synthetic */ Class class$nu$fw$jeti$events$IQResultListener;

    public static void init(Backend backend) {
        PluginsInfo.loadLibrary((String)"jmf");
        PluginsInfo.loadLibrary((String)"jstun");
        PluginsInfo.loadLibrary((String)"Speex");
        PluginsInfo.loadLibrary((String)"jspeex");
        PluginsInfo.loadLibrary((String)"retroweaver");
        plugin = new Plugin(backend);
    }

    public Plugin(Backend backend) {
        this.endVoiceMenu.setEnabled(false);
        this.endVoiceMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = Plugin.this.sessions.values().iterator();
                while (iterator.hasNext()) {
                    JingleSession jingleSession = (JingleSession)iterator.next();
                    try {
                        jingleSession.terminate();
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                }
                Plugin.this.sessions.clear();
                Plugin.this.endVoiceMenu.setEnabled(false);
            }
        });
        backend.getMain().addToMenu(this.endVoiceMenu);
        backend.getMain().addToRosterMenu(I18N.gettext((String)"jingle.voice"), new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                JingleSession jingleSession = (JingleSession)Plugin.this.sessions.get(jIDStatus.getCompleteJID());
                if (jingleSession != null) {
                    try {
                        jingleSession.terminate();
                        System.out.println("session removing because not yet removed");
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                }
                try {
                    OutgoingJingleSession outgoingJingleSession = Plugin.this.manager.createOutgoingJingleSession(jIDStatus.getCompleteJID());
                    outgoingJingleSession.addListener(Plugin.this.createSessionListener(jIDStatus.getCompleteJID()));
                    outgoingJingleSession.start();
                    Plugin.this.sessions.put(jIDStatus.getCompleteJID(), outgoingJingleSession);
                    Plugin.this.endVoiceMenu.setEnabled(true);
                }
                catch (XMPPException xMPPException) {
                    xMPPException.printStackTrace();
                }
            }
        });
        String string = "stun.xten.net";
        int n = 3478;
        ICETransportManager iCETransportManager = new ICETransportManager(backend, string, n);
        String string2 = "javasound://8000";
        MultiMediaManager multiMediaManager = new MultiMediaManager();
        multiMediaManager.addMediaManager(new JmfMediaManager(string2));
        multiMediaManager.addMediaManager(new SpeexMediaManager());
        if (System.getProperty("codec") != null) {
            try {
                int n2 = Integer.parseInt(System.getProperty("codec"));
                multiMediaManager.setPreferredPayloadType(multiMediaManager.getPayloads().get(n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.manager = new JingleManager(backend, iCETransportManager, multiMediaManager);
        this.manager.addCreationListener(iCETransportManager);
        this.manager.addJingleSessionRequestListener(new JingleSessionRequestListener(){

            public void sessionRequested(final JingleSessionRequest jingleSessionRequest) {
                JID jID = jingleSessionRequest.getFrom();
                JingleSession jingleSession = (JingleSession)Plugin.this.sessions.get(jID);
                if (jingleSession != null) {
                    try {
                        jingleSession.terminate();
                        System.out.println("incom session removing because not yet removed");
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                    return;
                }
                String string = jID.getUser();
                JIDStatus jIDStatus = Roster.getJIDStatus((JID)jID);
                if (jIDStatus != null) {
                    string = jIDStatus.getNick();
                }
                Object[] objectArray = new Object[]{I18N.gettext((String)"jeti.Decline"), I18N.gettext((String)"jeti.Answer")};
                Popups.showOptionDialog((Object)MessageFormat.format(I18N.gettext((String)"jingle.{0}_calls,_answer_call?"), string), (String)I18N.gettext((String)"jingle.New Call"), (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[1], (Popups.OptionChoosed)new Popups.OptionChoosed(){

                    public void optionChoosed(int n) {
                        if (n == 1) {
                            try {
                                IncomingJingleSession incomingJingleSession = jingleSessionRequest.accept();
                                incomingJingleSession.start();
                                incomingJingleSession.addListener(Plugin.this.createSessionListener(jingleSessionRequest.getFrom()));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            jingleSessionRequest.reject();
                        }
                    }
                });
            }
        });
        backend.addExtensionHandler("http://jabber.org/protocol/jingle", (ExtensionHandler)new JingleProvider(this.manager));
        backend.addExtensionHandler("http://jabber.org/protocol/jingle/description/audio", (ExtensionHandler)new JingleContentDescriptionProvider.Audio());
        backend.addExtensionHandler("http://jabber.org/protocol/jingle/transport/ice", (ExtensionHandler)new JingleTransportProvider.Ice());
        backend.addExtensionHandler("http://jabber.org/protocol/jingle/transport/raw-udp", (ExtensionHandler)new JingleTransportProvider.RawUdp());
        backend.addExtensionHandler("http://jabber.org/protocol/jingle/info/audio", (ExtensionHandler)new JingleContentInfoProvider.Audio());
        backend.addExtensionHandler("http://www.jivesoftware.com/protocol/rtpbridge", (ExtensionHandler)new RTPBridge.Provider());
        backend.addExtensionHandler("google:jingleinfo", (ExtensionHandler)new STUN.Provider());
        backend.addCapability(NAME, "http://www.xmpp.org/extensions/xep-0166.html#ns");
        Class<?> clazz = class$nu$fw$jeti$events$IQResultListener;
        if (clazz == null) {
            clazz = class$nu$fw$jeti$events$IQResultListener = new IQResultListener[0].getClass().getComponentType();
        }
        backend.addListener((Class)clazz, (JETIListener)new IQResultListener(){

            public void iqResult(InfoQuery infoQuery) {
                Iterator<JingleSession> iterator = Plugin.this.manager.getAllSessions().iterator();
                while (iterator.hasNext()) {
                    JingleSession jingleSession = iterator.next();
                    try {
                        jingleSession.respond(new Jingle(infoQuery));
                    }
                    catch (XMPPException xMPPException) {
                        xMPPException.printStackTrace();
                    }
                }
            }
        });
    }

    private JingleSessionListener createSessionListener(final JID jID) {
        return new JingleSessionListener(){

            public void sessionRedirected(String string, JingleSession jingleSession) {
            }

            public void sessionMediaReceived(JingleSession jingleSession, String string) {
            }

            public void sessionEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, JingleSession jingleSession) {
                Plugin.this.sessions.put(jID, jingleSession);
                Plugin.this.endVoiceMenu.setEnabled(true);
            }

            public void sessionDeclined(String string, JingleSession jingleSession) {
            }

            public void sessionClosedOnError(XMPPException xMPPException, JingleSession jingleSession) {
                Plugin.this.sessions.remove(jID);
                Plugin.this.endVoiceMenu.setEnabled(false);
            }

            public void sessionClosed(String string, JingleSession jingleSession) {
                Plugin.this.sessions.remove(jID);
                Plugin.this.endVoiceMenu.setEnabled(false);
            }
        };
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        Iterator<JingleSession> iterator = Plugin.plugin.sessions.values().iterator();
        while (iterator.hasNext()) {
            JingleSession jingleSession = iterator.next();
            try {
                jingleSession.terminate();
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
        backend.removeExtensionHandler("http://jabber.org/protocol/jingle");
        backend.removeExtensionHandler("http://jabber.org/protocol/jingle/description/audio");
        backend.removeExtensionHandler("http://jabber.org/protocol/jingle/transport/ice");
        backend.removeExtensionHandler("http://jabber.org/protocol/jingle/transport/raw-udp");
        backend.removeExtensionHandler("http://jabber.org/protocol/jingle/info/audio");
        backend.removeExtensionHandler("http://www.jivesoftware.com/protocol/rtpbridge");
        backend.getMain().removeFromMenu(Plugin.plugin.endVoiceMenu);
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)I18N.gettext((String)"jingle.voice")));
        plugin = null;
    }
}

