/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaSession;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.JMFInit;
import nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf.AudioMediaSession;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmfMediaManager
extends JingleMediaManager {
    private List<PayloadType> payloads = new ArrayList<PayloadType>();
    private String mediaLocator = null;

    public JmfMediaManager() {
        this.setupPayloads();
    }

    public JmfMediaManager(String string) {
        this.mediaLocator = string;
        this.setupPayloads();
    }

    @Override
    public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, JingleSession jingleSession) {
        return new AudioMediaSession(payloadType, transportCandidate, transportCandidate2, this.mediaLocator, jingleSession);
    }

    private void setupPayloads() {
        this.payloads.add(new PayloadType.Audio(3, "gsm"));
        this.payloads.add(new PayloadType.Audio(4, "g723"));
        this.payloads.add(new PayloadType.Audio(0, "PCMU", 16000));
    }

    @Override
    public List<PayloadType> getPayloads() {
        return this.payloads;
    }

    public String getMediaLocator() {
        return this.mediaLocator;
    }

    public void setMediaLocator(String string) {
        this.mediaLocator = string;
    }

    public static void setupJMF() {
        File file;
        String string = System.getProperty("user.home");
        File file2 = new File(string, ".jmf");
        String string2 = System.getProperty("java.class.path");
        string2 = new StringBuffer().append(string2).append(System.getProperty("path.separator")).append(file2.getAbsolutePath()).toString();
        System.setProperty("java.class.path", string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(file2, "jmf.properties")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println("Failed to create jmf.properties");
                iOException.printStackTrace();
            }
        }
        JmfMediaManager.runLinuxPreInstall();
        new JMFInit(null, false);
    }

    private static void runLinuxPreInstall() {
    }
}

