/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.nat;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.nat.RTPBridge;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolver;

public class BridgedResolver
extends TransportResolver {
    Backend connection;
    Random random = new Random();
    long sid;

    public BridgedResolver(Backend backend) {
        this.connection = backend;
    }

    public synchronized void resolve(JingleSession jingleSession) {
        System.out.println("bridged resolver");
        this.setResolveInit();
        this.clearCandidates();
        this.sid = Math.abs(this.random.nextLong());
        InfoQuery infoQuery = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
        this.connection.send(infoQuery, new IQResultListener(){

            public void iqResult(InfoQuery infoQuery) {
                RTPBridge rTPBridge = (RTPBridge)infoQuery.getIQExtension();
                String string = BridgedResolver.getLocalHost();
                TransportCandidate.Fixed fixed = new TransportCandidate.Fixed(rTPBridge.getIp(), rTPBridge.getPortA());
                fixed.setLocalIp(string);
                TransportCandidate.Fixed fixed2 = new TransportCandidate.Fixed(rTPBridge.getIp(), rTPBridge.getPortB());
                fixed2.setLocalIp(string);
                fixed.setSymmetric(fixed2);
                fixed2.setSymmetric(fixed);
                fixed.setPassword(rTPBridge.getPass());
                fixed2.setPassword(rTPBridge.getPass());
                fixed.setSessionId(rTPBridge.getSid());
                fixed2.setSessionId(rTPBridge.getSid());
                fixed.setConnection(BridgedResolver.this.connection);
                fixed2.setConnection(BridgedResolver.this.connection);
                BridgedResolver.this.addCandidate(fixed);
                BridgedResolver.this.setResolveEnd();
            }
        }, 10);
    }

    public void initialize() throws Exception {
        this.clearCandidates();
        RTPBridge.serviceAvailable(this.connection, null);
        this.setInitialized();
    }

    public void cancel() {
    }

    public static String getLocalHost() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress() || inetAddress instanceof Inet6Address) continue;
                return inetAddress.getHostAddress();
            }
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "127.0.0.1";
        }
    }
}

