/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.nat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleTransportListener;
import nu.fw.jeti.plugins.jingle.jingle.nat.ICECandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolver;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolverListener;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleTransport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class TransportNegotiator
extends JingleNegotiator {
    public static final int CANDIDATES_ACCEPT_PERIOD = 4000;
    private final JingleSession session;
    private final TransportResolver resolver;
    private final List<TransportCandidate> offeredCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> remoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> validRemoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> acceptedRemoteCandidates = new ArrayList<TransportCandidate>();
    private TransportCandidate acceptedLocalCandidate;
    private Thread resultThread;
    private TransportResolverListener.Resolver resolverListener;
    private final Inviting inviting;
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;

    public TransportNegotiator(JingleSession jingleSession, TransportResolver transportResolver) {
        super(jingleSession.getConnection());
        this.session = jingleSession;
        this.resolver = transportResolver;
        this.resultThread = null;
        this.inviting = new Inviting(this);
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
    }

    public abstract JingleTransport getJingleTransport(TransportCandidate var1);

    public abstract boolean acceptableTransportCandidate(TransportCandidate var1, List<TransportCandidate> var2);

    public final TransportCandidate getBestLocalCandidate() {
        return this.resolver.getPreferredCandidate();
    }

    private void setAcceptedLocalCandidate(TransportCandidate transportCandidate) throws XMPPException {
        for (int i = 0; i < this.resolver.getCandidateCount(); ++i) {
            if (!this.resolver.getCandidate(i).getIp().equals(transportCandidate.getIp()) || this.resolver.getCandidate(i).getPort() != transportCandidate.getPort()) continue;
            this.acceptedLocalCandidate = this.resolver.getCandidate(i);
            return;
        }
        throw new XMPPException("Local transport candidate has not be offered.");
    }

    public TransportCandidate getAcceptedLocalCandidate() {
        return this.acceptedLocalCandidate;
    }

    @Override
    public void close() {
        super.close();
    }

    public List<TransportCandidate> getOfferedCandidates() {
        return this.offeredCandidates;
    }

    public abstract TransportCandidate getBestRemoteCandidate();

    private List getRemoteCandidates() {
        return this.remoteCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null && this.acceptableTransportCandidate(transportCandidate, this.offeredCandidates)) {
            List<TransportCandidate> list = this.remoteCandidates;
            synchronized (list) {
                this.remoteCandidates.add(transportCandidate);
            }
            this.checkRemoteCandidate(transportCandidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOfferedCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null) {
            List<TransportCandidate> list = this.offeredCandidates;
            synchronized (list) {
                this.offeredCandidates.add(transportCandidate);
            }
        }
    }

    private void checkRemoteCandidate(final TransportCandidate transportCandidate) {
        transportCandidate.addListener(new TransportResolverListener.Checker(){

            public void candidateChecked(TransportCandidate transportCandidate2, boolean bl) {
                if (bl && !(TransportNegotiator.this.getState() instanceof Active)) {
                    TransportNegotiator.this.addValidRemoteCandidate(transportCandidate);
                }
            }

            public void candidateChecking(TransportCandidate transportCandidate2) {
            }
        });
        transportCandidate.check(this.resolver.getCandidatesList());
    }

    private boolean isEstablished() {
        return this.getBestRemoteCandidate() != null && this.getAcceptedLocalCandidate() != null;
    }

    public final boolean isFullyEstablished() {
        return this.isEstablished() && this.getState() == this.active;
    }

    private void delayedCheckBestCandidate(final JingleSession jingleSession, final Jingle jingle) {
        if (this.resultThread == null && !this.getRemoteCandidates().isEmpty()) {
            this.resultThread = new Thread(new Runnable(){

                public void run() {
                    TransportCandidate transportCandidate;
                    Object object;
                    Object object2;
                    int n = 7000;
                    int n2 = (int)Math.ceil(n / 1000);
                    for (int i = 0; i < n2 - 1; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        System.out.println("waiting for candidates");
                        TransportCandidate transportCandidate2 = TransportNegotiator.this.getBestRemoteCandidate();
                        object2 = TransportNegotiator.this.getState();
                        System.out.println("state " + object2);
                        if (transportCandidate2 == null || object2 != TransportNegotiator.this.pending && object2 != TransportNegotiator.this.active) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(transportCandidate2)) {
                            object = new Jingle(Jingle.Action.TRANSPORTACCEPT);
                            ((Jingle)((Object)object)).addTransport(TransportNegotiator.this.getJingleTransport(transportCandidate2));
                            jingleSession.sendFormattedJingle(jingle, (Jingle)((Object)object));
                            TransportNegotiator.this.acceptedRemoteCandidates.add(transportCandidate2);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setState(TransportNegotiator.this.active);
                        break;
                    }
                    if ((transportCandidate = TransportNegotiator.this.getBestRemoteCandidate()) == null) {
                        Object object3;
                        boolean bl = false;
                        object2 = TransportNegotiator.this.remoteCandidates.iterator();
                        while (object2.hasNext()) {
                            object = (TransportCandidate)object2.next();
                            if (!(object instanceof ICECandidate) || !((ICECandidate)(object3 = (ICECandidate)object)).getType().equals("relay")) continue;
                            TransportNegotiator.this.addValidRemoteCandidate((TransportCandidate)object3);
                            bl = true;
                        }
                        if (!bl) {
                            TransportCandidate transportCandidate3;
                            boolean bl2 = false;
                            object = TransportNegotiator.this.offeredCandidates.iterator();
                            while (object.hasNext()) {
                                object3 = (TransportCandidate)object.next();
                                if (!(object3 instanceof ICECandidate) || !((ICECandidate)(transportCandidate3 = object3)).getType().equals("relay")) continue;
                                bl2 = true;
                            }
                            if (bl2) {
                                ICECandidate iCECandidate;
                                boolean bl3 = false;
                                object3 = TransportNegotiator.this.remoteCandidates.iterator();
                                while (object3.hasNext()) {
                                    transportCandidate3 = (TransportCandidate)object3.next();
                                    if (!(transportCandidate3 instanceof ICECandidate) || !(iCECandidate = (ICECandidate)transportCandidate3).getType().equals((Object)ICECandidate.Type.srflx)) continue;
                                    TransportNegotiator.this.addValidRemoteCandidate(iCECandidate);
                                    bl3 = true;
                                }
                                if (!bl3) {
                                    object3 = TransportNegotiator.this.remoteCandidates.iterator();
                                    while (object3.hasNext()) {
                                        transportCandidate3 = (TransportCandidate)object3.next();
                                        if (!(transportCandidate3 instanceof ICECandidate)) continue;
                                        iCECandidate = (ICECandidate)transportCandidate3;
                                        TransportNegotiator.this.addValidRemoteCandidate(iCECandidate);
                                    }
                                }
                            }
                        }
                    }
                    for (int i = 0; i < 6; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        transportCandidate = TransportNegotiator.this.getBestRemoteCandidate();
                        JingleNegotiator.State state = TransportNegotiator.this.getState();
                        if (transportCandidate == null || state != TransportNegotiator.this.pending && state != TransportNegotiator.this.active) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(transportCandidate)) {
                            Jingle jingle2 = new Jingle(Jingle.Action.TRANSPORTACCEPT);
                            jingle2.addTransport(TransportNegotiator.this.getJingleTransport(transportCandidate));
                            jingleSession.sendFormattedJingle(jingle, jingle2);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(transportCandidate);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setState(TransportNegotiator.this.active);
                        break;
                    }
                    if (TransportNegotiator.this.getState() == null || !TransportNegotiator.this.getState().equals(TransportNegotiator.this.active)) {
                        try {
                            TransportNegotiator.this.session.terminate("Unable to negotiate session. This may be caused by firewall configuration problems.");
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                    }
                }
            }, "Waiting for all the transport candidates checks...");
            this.resultThread.setName("Transport Resolver Result");
            this.resultThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidRemoteCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null) {
            List<TransportCandidate> list = this.validRemoteCandidates;
            synchronized (list) {
                System.out.println(new StringBuffer().append("ADDED Valid Cand: ").append(transportCandidate.getIp()).append(":").append(transportCandidate.getPort()).toString());
                this.validRemoteCandidates.add(transportCandidate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayList getValidRemoteCandidatesList() {
        List<TransportCandidate> list = this.validRemoteCandidates;
        synchronized (list) {
            return new ArrayList<TransportCandidate>(this.validRemoteCandidates);
        }
    }

    public final Iterator getValidRemoteCandidates() {
        return Collections.unmodifiableList(this.getRemoteCandidates()).iterator();
    }

    private void addRemoteCandidates(List list) {
        if (list != null && list.size() > 0) {
            for (Object e : list) {
                this.addRemoteCandidate((TransportCandidate)e);
            }
        }
    }

    private static ArrayList obtainCandidatesList(Jingle jingle) {
        ArrayList<TransportCandidate> arrayList = new ArrayList<TransportCandidate>();
        if (jingle != null) {
            Iterator iterator = jingle.getTransports();
            while (iterator.hasNext()) {
                JingleTransport jingleTransport = (JingleTransport)((Object)iterator.next());
                Iterator iterator2 = jingleTransport.getCandidates();
                while (iterator2.hasNext()) {
                    JingleTransport.JingleTransportCandidate jingleTransportCandidate = (JingleTransport.JingleTransportCandidate)iterator2.next();
                    TransportCandidate transportCandidate = jingleTransportCandidate.getMediaTransport();
                    arrayList.add(transportCandidate);
                }
            }
        }
        return arrayList;
    }

    private boolean isOfferStarted() {
        return this.resolver.isResolving() || this.resolver.isResolved();
    }

    private synchronized void sendTransportCandidateOffer(TransportCandidate transportCandidate) {
        if (!transportCandidate.isNull()) {
            this.addOfferedCandidate(transportCandidate);
            this.session.sendFormattedJingle(new Jingle(this.getJingleTransport(transportCandidate)));
        }
    }

    private void sendTransportCandidatesOffer() throws XMPPException {
        List<TransportCandidate> list = this.resolver.getCandidatesList();
        list.removeAll(this.offeredCandidates);
        for (TransportCandidate transportCandidate : list) {
            this.sendTransportCandidateOffer(transportCandidate);
        }
        if (this.resolverListener == null) {
            this.resolverListener = new TransportResolverListener.Resolver(){

                public void candidateAdded(TransportCandidate transportCandidate) {
                    TransportNegotiator.this.sendTransportCandidateOffer(transportCandidate);
                }

                public void end() {
                }

                public void init() {
                }
            };
            this.resolver.addListener(this.resolverListener);
        }
        if (!this.resolver.isResolving() && !this.resolver.isResolved()) {
            System.out.println("RESOLVER CALLED");
            this.resolver.resolve(this.session);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Jingle dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        System.out.println("transport info dispatching");
        Jingle jingle2 = null;
        if (this.invalidState()) {
            if (jingle == null) {
                this.setState(this.inviting);
                jingle2 = this.getState().eventInvite();
            } else {
                if (!(jingle instanceof Jingle)) throw new IllegalStateException("Invitation IQ received is not a Jingle packet in Transport negotiator.");
                this.setState(this.accepting);
                jingle2 = this.getState().eventInitiate(jingle);
            }
        } else {
            Jingle jingle3;
            Jingle.Action action;
            if (jingle == null) {
                return null;
            }
            if (jingle.getType().equals("error")) {
                this.getState().eventError(jingle);
            } else if (jingle.getType().equals("result")) {
                System.err.println(new StringBuffer().append("acking ").append(jingle.getPacketID()).toString());
                if (this.isExpectedId(jingle.getPacketID())) {
                    System.err.println(new StringBuffer().append("acked ").append(jingle.getPacketID()).toString());
                    jingle2 = this.getState().eventAck(jingle);
                    this.removeExpectedId(jingle.getPacketID());
                }
            } else if (jingle instanceof Jingle && (action = (jingle3 = jingle).getAction()) != null) {
                if (action.equals((Object)Jingle.Action.TRANSPORTACCEPT)) {
                    jingle2 = this.getState().eventAccept(jingle3);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTDECLINE)) {
                    jingle2 = this.getState().eventDecline(jingle3);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTINFO)) {
                    jingle2 = this.getState().eventInfo(jingle3);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTMODIFY)) {
                    jingle2 = this.getState().eventModify(jingle3);
                }
            }
        }
        if (string != null) {
            this.addExpectedId(string);
            return jingle2;
        } else {
            if (jingle2 == null) return jingle2;
            this.addExpectedId(jingle2.getPacketID());
        }
        return jingle2;
    }

    private void triggerTransportEstablished(TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        ArrayList arrayList = this.getListenersList();
        for (Object e : arrayList) {
            JingleListener jingleListener = (JingleListener)e;
            if (!(jingleListener instanceof JingleTransportListener)) continue;
            JingleTransportListener jingleTransportListener = (JingleTransportListener)jingleListener;
            System.out.println(new StringBuffer().append("triggerTransportEstablished ").append(transportCandidate.getLocalIp()).append(":").append(transportCandidate.getPort()).append("|").append(transportCandidate2.getIp()).append(":").append(transportCandidate2.getPort()).toString());
            jingleTransportListener.transportEstablished(transportCandidate, transportCandidate2);
        }
    }

    private void triggerTransportClosed(TransportCandidate transportCandidate) {
        ArrayList arrayList = this.getListenersList();
        for (Object e : arrayList) {
            JingleListener jingleListener = (JingleListener)e;
            if (!(jingleListener instanceof JingleTransportListener)) continue;
            JingleTransportListener jingleTransportListener = (JingleTransportListener)jingleListener;
            jingleTransportListener.transportClosed(transportCandidate);
        }
    }

    @Override
    public IQExtension dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        return this.dispatchIncomingPacket(jingle, string);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ice
    extends TransportNegotiator {
        public Ice(JingleSession jingleSession, TransportResolver transportResolver) {
            super(jingleSession, transportResolver);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate transportCandidate) {
            JingleTransport.Ice ice = new JingleTransport.Ice();
            ice.addCandidate(new JingleTransport.Ice.Candidate(transportCandidate));
            return ice;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ICECandidate iCECandidate = null;
            ArrayList arrayList = this.getValidRemoteCandidatesList();
            if (!arrayList.isEmpty()) {
                int n = -1;
                ICECandidate iCECandidate2 = null;
                for (ICECandidate iCECandidate3 : arrayList) {
                    if (iCECandidate3.getPreference() <= n) continue;
                    iCECandidate2 = iCECandidate3;
                    n = iCECandidate3.getPreference();
                }
                iCECandidate = iCECandidate2;
            }
            if (iCECandidate != null && iCECandidate.getType().equals("relay")) {
                System.out.println("Relay Type");
            }
            return iCECandidate;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate transportCandidate, List<TransportCandidate> list) {
            return transportCandidate instanceof ICECandidate;
        }

        @Override
        public IQExtension dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
            return super.dispatchIncomingPacket(jingle, string);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RawUdp
    extends TransportNegotiator {
        public RawUdp(JingleSession jingleSession, TransportResolver transportResolver) {
            super(jingleSession, transportResolver);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate transportCandidate) {
            JingleTransport.RawUdp rawUdp = new JingleTransport.RawUdp();
            rawUdp.addCandidate(new JingleTransport.RawUdp.Candidate(transportCandidate));
            return rawUdp;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ArrayList arrayList = this.getValidRemoteCandidatesList();
            if (!arrayList.isEmpty()) {
                System.out.println("RAW CAND");
                return (TransportCandidate)arrayList.get(0);
            }
            System.out.println("No Remote Candidate");
            return null;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate transportCandidate, List<TransportCandidate> list) {
            return transportCandidate instanceof TransportCandidate.Fixed;
        }

        @Override
        public IQExtension dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
            return super.dispatchIncomingPacket(jingle, string);
        }
    }

    public final class Active
    extends JingleNegotiator.State {
        public Active(TransportNegotiator transportNegotiator2) {
            super(transportNegotiator2);
        }

        public void eventEnter() {
            System.out.println("Transport stabilished");
            TransportNegotiator.this.triggerTransportEstablished(TransportNegotiator.this.getAcceptedLocalCandidate(), TransportNegotiator.this.getBestRemoteCandidate());
            super.eventEnter();
        }

        public void eventExit() {
            TransportNegotiator.this.triggerTransportClosed(null);
            super.eventExit();
        }
    }

    public final class Pending
    extends JingleNegotiator.State {
        public Pending(TransportNegotiator transportNegotiator2) {
            super(transportNegotiator2);
        }

        public Jingle eventAccept(Jingle jingle) throws XMPPException {
            Jingle jingle2 = null;
            ArrayList arrayList = TransportNegotiator.obtainCandidatesList(jingle);
            if (!arrayList.isEmpty()) {
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    TransportCandidate transportCandidate = (TransportCandidate)object.next();
                    System.out.println("Cand: " + transportCandidate.getIp());
                }
                object = (TransportCandidate)arrayList.get(0);
                TransportNegotiator.this.setAcceptedLocalCandidate((TransportCandidate)object);
                if (TransportNegotiator.this.isEstablished()) {
                    System.out.println("SET ACTIVE");
                    TransportNegotiator.this.setState(TransportNegotiator.this.active);
                }
            }
            return jingle2;
        }

        public Jingle eventInfo(Jingle jingle) throws XMPPException {
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.addRemoteCandidates(TransportNegotiator.obtainCandidatesList(jingle));
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jingle);
            return null;
        }

        public Jingle eventDecline(Jingle jingle) throws JingleNegotiator.JingleException {
            throw new JingleNegotiator.JingleException("No common payload found.");
        }
    }

    public final class Accepting
    extends JingleNegotiator.State {
        public Accepting(TransportNegotiator transportNegotiator2) {
            super(transportNegotiator2);
        }

        public Jingle eventInitiate(Jingle jingle) throws XMPPException {
            System.out.println("eventinitiate");
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jingle);
            TransportNegotiator.this.setState(TransportNegotiator.this.pending);
            return super.eventInitiate(jingle);
        }
    }

    public final class Inviting
    extends JingleNegotiator.State {
        public Inviting(TransportNegotiator transportNegotiator2) {
            super(transportNegotiator2);
        }

        public Jingle eventInvite() {
            return new Jingle(TransportNegotiator.this.getJingleTransport(null));
        }

        public Jingle eventInfo(Jingle jingle) throws XMPPException {
            TransportNegotiator.this.addRemoteCandidates(TransportNegotiator.obtainCandidatesList(jingle));
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jingle);
            return null;
        }

        public Jingle eventAck(Jingle jingle) throws XMPPException {
            System.out.println("eventAck");
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.setState(TransportNegotiator.this.pending);
            return super.eventAck(jingle);
        }
    }
}

